/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service.custom.script;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.xdi.exception.PythonException;
import org.xdi.model.ScriptLocationType;
import org.xdi.model.SimpleCustomProperty;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.model.custom.script.model.CustomScript;
import org.xdi.model.custom.script.type.BaseExternalType;
import org.xdi.service.PythonService;
import org.xdi.service.custom.script.AbstractCustomScriptService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.APPLICATION)
@Name(value="customScriptManager")
@AutoCreate
public class CustomScriptManager
implements Serializable {
    private static final long serialVersionUID = -4225890597520443390L;
    private static final String EVENT_TYPE = "CustomScriptHolderTimerEvent";
    public static final String MODIFIED_EVENT_TYPE = "CustomScriptModifiedEvent";
    private static final int DEFAULT_INTERVAL = 30;
    public static final String[] CUSTOM_SCRIPT_CHECK_ATTRIBUTES = new String[]{"dn", "inum", "oxRevision", "oxScriptType", "oxModuleProperty", "gluuStatus"};
    @Logger
    protected Log log;
    @In
    private PythonService pythonService;
    @In(value="customScriptService")
    protected AbstractCustomScriptService customScriptService;
    protected List<CustomScriptType> supportedCustomScriptTypes;
    private Map<String, CustomScriptConfiguration> customScriptConfigurations;
    private AtomicBoolean isActive;
    private long lastFinishedTime;
    private Map<CustomScriptType, List<CustomScriptConfiguration>> customScriptConfigurationsByScriptType;

    public void init(List<CustomScriptType> supportedCustomScriptTypes) {
        this.supportedCustomScriptTypes = supportedCustomScriptTypes;
        this.isActive = new AtomicBoolean(false);
        this.lastFinishedTime = System.currentTimeMillis();
        this.reload();
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(60000L), Long.valueOf(30000L)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"CustomScriptHolderTimerEvent"})
    @Asynchronous
    public void reloadTimerEvent() {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reload();
            this.isActive.set(false);
        }
        catch (Throwable ex) {
            try {
                this.log.error((Object)"Exception happened while reloading custom scripts configuration", ex, new Object[0]);
                this.isActive.set(false);
            }
            catch (Throwable throwable) {
                this.isActive.set(false);
                this.lastFinishedTime = System.currentTimeMillis();
                this.log.trace((Object)"Last finished time '{0}'", new Object[]{new Date(this.lastFinishedTime)});
                throw throwable;
            }
            this.lastFinishedTime = System.currentTimeMillis();
            this.log.trace((Object)"Last finished time '{0}'", new Object[]{new Date(this.lastFinishedTime)});
        }
        this.lastFinishedTime = System.currentTimeMillis();
        this.log.trace((Object)"Last finished time '{0}'", new Object[]{new Date(this.lastFinishedTime)});
    }

    public void destroy() {
        this.log.debug((Object)"Destroying custom scripts configurations", new Object[0]);
        if (this.customScriptConfigurations == null) {
            return;
        }
        for (Map.Entry<String, CustomScriptConfiguration> customScriptConfigurationEntry : this.customScriptConfigurations.entrySet()) {
            this.destroyCustomScript(customScriptConfigurationEntry.getValue());
        }
    }

    private void reload() {
        boolean modified = this.reloadImpl();
        if (modified) {
            Events.instance().raiseEvent(MODIFIED_EVENT_TYPE, new Object[0]);
        }
    }

    private boolean reloadImpl() {
        List<CustomScript> customScripts = this.customScriptService.findCustomScripts(this.supportedCustomScriptTypes, CUSTOM_SCRIPT_CHECK_ATTRIBUTES);
        ReloadResult reloadResult = this.reloadCustomScriptConfigurations(this.customScriptConfigurations, customScripts);
        this.customScriptConfigurations = reloadResult.getCustomScriptConfigurations();
        this.customScriptConfigurationsByScriptType = this.groupCustomScriptConfigurationsByScriptType(this.customScriptConfigurations);
        return reloadResult.isModified();
    }

    private ReloadResult reloadCustomScriptConfigurations(Map<String, CustomScriptConfiguration> customScriptConfigurations, List<CustomScript> newCustomScripts) {
        HashMap<Object, Object> newCustomScriptConfigurations;
        boolean modified = false;
        if (customScriptConfigurations == null) {
            newCustomScriptConfigurations = new HashMap();
            modified = true;
        } else {
            newCustomScriptConfigurations = new HashMap<String, CustomScriptConfiguration>(customScriptConfigurations);
        }
        ArrayList<String> newSupportedCustomScriptInums = new ArrayList<String>();
        for (CustomScript newCustomScript : newCustomScripts) {
            if (!newCustomScript.isEnabled()) continue;
            if (ScriptLocationType.FILE == newCustomScript.getLocationType()) {
                long fileModifiactionTime = this.getFileModificationTime(newCustomScript.getLocationPath());
                newCustomScript.setRevision(fileModifiactionTime);
            }
            String newSupportedCustomScriptInum = StringHelper.toLowerCase((String)newCustomScript.getInum());
            newSupportedCustomScriptInums.add(newSupportedCustomScriptInum);
            CustomScriptConfiguration prevCustomScriptConfiguration = (CustomScriptConfiguration)newCustomScriptConfigurations.get(newSupportedCustomScriptInum);
            if (prevCustomScriptConfiguration != null && prevCustomScriptConfiguration.getCustomScript().getRevision() == newCustomScript.getRevision()) continue;
            if (prevCustomScriptConfiguration != null) {
                this.destroyCustomScript(prevCustomScriptConfiguration);
            }
            CustomScript loadedCustomScript = this.customScriptService.getCustomScriptByDn(newCustomScript.getScriptType().getCustomScriptModel(), newCustomScript.getDn());
            HashMap<String, SimpleCustomProperty> newConfigurationAttributes = new HashMap<String, SimpleCustomProperty>();
            List<SimpleCustomProperty> simpleCustomProperties = loadedCustomScript.getConfigurationProperties();
            if (simpleCustomProperties == null) {
                simpleCustomProperties = new ArrayList<SimpleCustomProperty>(0);
            }
            for (SimpleCustomProperty simpleCustomProperty : simpleCustomProperties) {
                newConfigurationAttributes.put(simpleCustomProperty.getValue1(), simpleCustomProperty);
            }
            if (ScriptLocationType.FILE == loadedCustomScript.getLocationType()) {
                String scriptFromFile;
                long fileModifiactionTime = this.getFileModificationTime(loadedCustomScript.getLocationPath());
                loadedCustomScript.setRevision(fileModifiactionTime);
                if (fileModifiactionTime != 0L && StringHelper.isNotEmpty((String)(scriptFromFile = this.loadFromFile(loadedCustomScript.getLocationPath())))) {
                    loadedCustomScript.setScript(scriptFromFile);
                }
            }
            BaseExternalType newCustomScriptExternalType = this.createExternalType(loadedCustomScript, newConfigurationAttributes);
            CustomScriptConfiguration newCustomScriptConfiguration = new CustomScriptConfiguration(loadedCustomScript, newCustomScriptExternalType, newConfigurationAttributes);
            newCustomScriptConfigurations.put(newSupportedCustomScriptInum, newCustomScriptConfiguration);
            modified = true;
        }
        Iterator it = newCustomScriptConfigurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry externalAuthenticatorConfigurationEntry = it.next();
            String prevSupportedCustomScriptInum = (String)externalAuthenticatorConfigurationEntry.getKey();
            if (newSupportedCustomScriptInums.contains(prevSupportedCustomScriptInum)) continue;
            this.destroyCustomScript((CustomScriptConfiguration)externalAuthenticatorConfigurationEntry.getValue());
            it.remove();
            modified = true;
        }
        return new ReloadResult(newCustomScriptConfigurations, modified);
    }

    private String loadFromFile(String locationPath) {
        try {
            String scriptFromFile = FileUtils.readFileToString((File)new File(locationPath));
            return scriptFromFile;
        }
        catch (IOException ex) {
            this.log.error((Object)"Faield to load script from '{0}'", new Object[]{locationPath});
            return null;
        }
    }

    private long getFileModificationTime(String locationPath) {
        File scriptFile = new File(locationPath);
        if (scriptFile.exists()) {
            return scriptFile.lastModified();
        }
        return 0L;
    }

    private boolean destroyCustomScript(CustomScriptConfiguration customScriptConfiguration) {
        String customScriptInum = customScriptConfiguration.getInum();
        boolean result = this.executeCustomScriptDestroy(customScriptConfiguration);
        if (!result) {
            this.log.error((Object)"Failed to destroy custom script '{0}' correctly", new Object[]{customScriptInum});
        }
        return result;
    }

    private Map<CustomScriptType, List<CustomScriptConfiguration>> groupCustomScriptConfigurationsByScriptType(Map<String, CustomScriptConfiguration> customScriptConfigurations) {
        HashMap<CustomScriptType, List<CustomScriptConfiguration>> newCustomScriptConfigurationsByScriptType = new HashMap<CustomScriptType, List<CustomScriptConfiguration>>();
        for (CustomScriptType customScriptType : this.supportedCustomScriptTypes) {
            ArrayList customConfigurationsByScriptType = new ArrayList();
            newCustomScriptConfigurationsByScriptType.put(customScriptType, customConfigurationsByScriptType);
        }
        for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurations.values()) {
            CustomScriptType customScriptType = customScriptConfiguration.getCustomScript().getScriptType();
            List customConfigurationsByScriptType = (List)newCustomScriptConfigurationsByScriptType.get((Object)customScriptType);
            customConfigurationsByScriptType.add(customScriptConfiguration);
        }
        return newCustomScriptConfigurationsByScriptType;
    }

    private BaseExternalType createExternalType(CustomScript customScript, Map<String, SimpleCustomProperty> configurationAttributes) {
        BaseExternalType externalType;
        String customScriptInum = customScript.getInum();
        try {
            externalType = this.createExternalTypeFromStringWithPythonException(customScript, configurationAttributes);
        }
        catch (PythonException ex) {
            this.log.error((Object)"Failed to prepare external type '{0}'", (Throwable)ex, new Object[]{customScriptInum});
            return null;
        }
        if (externalType == null) {
            this.log.debug((Object)"Using default external type class", new Object[0]);
            externalType = customScript.getScriptType().getDefaultImplementation();
        }
        return externalType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseExternalType createExternalTypeFromStringWithPythonException(CustomScript customScript, Map<String, SimpleCustomProperty> configurationAttributes) throws PythonException {
        String script = customScript.getScript();
        if (script == null) {
            return null;
        }
        CustomScriptType customScriptType = customScript.getScriptType();
        BaseExternalType externalType = null;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(script.getBytes("UTF-8"));
            externalType = this.pythonService.loadPythonScript(bis, customScriptType.getPythonClass(), customScriptType.getCustomScriptType(), new PyObject[]{new PyLong(System.currentTimeMillis())});
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bis);
        }
        IOUtils.closeQuietly((InputStream)bis);
        if (externalType == null) {
            return null;
        }
        boolean initialized = false;
        try {
            initialized = externalType.init(configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to initialize custom script: '{0}'", (Throwable)ex, new Object[]{customScript.getName()});
        }
        if (initialized) {
            return externalType;
        }
        return null;
    }

    public boolean executeCustomScriptDestroy(CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug((Object)"Executing python 'destroy' custom script method", new Object[0]);
            BaseExternalType externalType = customScriptConfiguration.getExternalType();
            Map<String, SimpleCustomProperty> configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalType.destroy(configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return false;
        }
    }

    public CustomScriptConfiguration getCustomScriptConfigurationByInum(String inum) {
        return this.customScriptConfigurations.get(inum);
    }

    public List<CustomScriptConfiguration> getCustomScriptConfigurationsByScriptType(CustomScriptType customScriptType) {
        return new ArrayList<CustomScriptConfiguration>((Collection)this.customScriptConfigurationsByScriptType.get((Object)customScriptType));
    }

    public List<CustomScriptConfiguration> getCustomScriptConfigurations() {
        return new ArrayList<CustomScriptConfiguration>(this.customScriptConfigurations.values());
    }

    public List<CustomScriptType> getSupportedCustomScriptTypes() {
        return this.supportedCustomScriptTypes;
    }

    public static CustomScriptManager instance() {
        return (CustomScriptManager)Component.getInstance(CustomScriptManager.class);
    }

    private class ReloadResult {
        private Map<String, CustomScriptConfiguration> customScriptConfigurations;
        private boolean modified;

        public ReloadResult(Map<String, CustomScriptConfiguration> customScriptConfigurations, boolean modified) {
            this.customScriptConfigurations = customScriptConfigurations;
            this.modified = modified;
        }

        public Map<String, CustomScriptConfiguration> getCustomScriptConfigurations() {
            return this.customScriptConfigurations;
        }

        public boolean isModified() {
            return this.modified;
        }
    }
}

