/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service.custom.script;

import com.unboundid.ldap.sdk.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.Log;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.custom.script.model.CustomScript;

public abstract class AbstractCustomScriptService
implements Serializable {
    private static final long serialVersionUID = -6187179012715072064L;
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    public void add(CustomScript customScript) {
        this.ldapEntryManager.persist((Object)customScript);
    }

    public void update(CustomScript customScript) {
        this.ldapEntryManager.merge((Object)customScript);
    }

    public void remove(CustomScript customScript) {
        this.ldapEntryManager.remove((Object)customScript);
    }

    public CustomScript getCustomScriptByDn(String customScriptDn) {
        return (CustomScript)((Object)this.ldapEntryManager.find(CustomScript.class, (Object)customScriptDn));
    }

    public CustomScript getCustomScriptByDn(Class<?> customScriptType, String customScriptDn) {
        return (CustomScript)((Object)this.ldapEntryManager.find(customScriptType, (Object)customScriptDn));
    }

    public List<CustomScript> findAllCustomScripts(String[] returnAttributes) {
        String baseDn = this.baseDn();
        List result = this.ldapEntryManager.findEntries(baseDn, CustomScript.class, returnAttributes, null);
        return result;
    }

    public List<CustomScript> findCustomScripts(List<CustomScriptType> customScriptTypes, String ... returnAttributes) {
        String baseDn = this.baseDn();
        if (customScriptTypes == null || customScriptTypes.size() == 0) {
            return this.findAllCustomScripts(returnAttributes);
        }
        ArrayList<Filter> customScriptTypeFilters = new ArrayList<Filter>();
        for (CustomScriptType customScriptType : customScriptTypes) {
            Filter customScriptTypeFilter = Filter.createEqualityFilter((String)"oxScriptType", (String)customScriptType.getValue());
            customScriptTypeFilters.add(customScriptTypeFilter);
        }
        Filter filter = Filter.createORFilter(customScriptTypeFilters);
        List result = this.ldapEntryManager.findEntries(baseDn, CustomScript.class, returnAttributes, filter);
        return result;
    }

    public String buildDn(String customScriptId) {
        StringBuilder dn = new StringBuilder();
        dn.append(String.format("inum=%s,", customScriptId));
        dn.append(this.baseDn());
        return dn.toString();
    }

    public abstract String baseDn();

    public static AbstractCustomScriptService instance() {
        if (!Contexts.isEventContextActive() && !Contexts.isApplicationContextActive()) {
            Lifecycle.beginCall();
        }
        return (AbstractCustomScriptService)Component.getInstance(AbstractCustomScriptService.class);
    }
}

