/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xdi.model.GluuImage;
import org.xdi.model.TrustContact;
import org.xdi.util.StringHelper;
import org.xml.sax.SAXException;

@Name(value="xmlService")
@Scope(value=ScopeType.APPLICATION)
@AutoCreate
public class XmlService {
    @Logger
    private Log log;
    private JAXBContext jaxbContext;
    private Marshaller jaxbMarshaller;
    private Unmarshaller jaxbUnmarshaller;

    @Create
    public void init() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GluuImage.class, TrustContact.class});
            this.jaxbMarshaller = this.jaxbContext.createMarshaller();
            this.jaxbUnmarshaller = this.jaxbContext.createUnmarshaller();
        }
        catch (JAXBException ex) {
            this.log.error((Object)"Failed to create JAXB marshaller and unmarshaller", (Throwable)ex, new Object[0]);
        }
    }

    public String getXMLFromGluuImage(GluuImage photo) {
        if (photo == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.jaxbMarshaller.marshal((Object)photo, (OutputStream)bos);
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to convert GluuImage {0} to XML", (Throwable)ex, new Object[]{photo});
            return null;
        }
    }

    public GluuImage getGluuImageFromXML(String xml) {
        if (xml == null) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            return (GluuImage)this.jaxbUnmarshaller.unmarshal((InputStream)bis);
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to create GluuImage from XML {0}", (Throwable)ex, new Object[]{xml});
            return null;
        }
    }

    public TrustContact getTrustContactFromXML(String xml) {
        if (xml == null) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            return (TrustContact)this.jaxbUnmarshaller.unmarshal((InputStream)bis);
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to create TrustContact from XML {0}", (Throwable)ex, new Object[]{xml});
            return null;
        }
    }

    public String getXMLFromTrustContact(TrustContact contact) {
        if (contact == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.jaxbMarshaller.marshal((Object)contact, (OutputStream)bos);
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to convert TrustContact {0} to XML", (Throwable)ex, new Object[]{contact});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXmlDocument(byte[] xmlDocumentBytes) throws SAXException, IOException, ParserConfigurationException {
        ByteArrayInputStream bis = new ByteArrayInputStream(xmlDocumentBytes);
        try {
            DocumentBuilderFactory fty = DocumentBuilderFactory.newInstance();
            fty.setNamespaceAware(true);
            fty.setXIncludeAware(false);
            fty.setExpandEntityReferences(false);
            fty.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            fty.setFeature("http://xml.org/sax/features/external-general-entities", false);
            fty.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document document = fty.newDocumentBuilder().parse(bis);
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    public String getNodeValue(Document xmlDocument, String xPathExpression, String attributeName) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression formXPathExpression = xPath.compile(xPathExpression);
        if (StringHelper.isEmpty((String)attributeName)) {
            String nodeValue = (String)formXPathExpression.evaluate(xmlDocument, XPathConstants.STRING);
            return nodeValue;
        }
        Node node = (Node)formXPathExpression.evaluate(xmlDocument, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        Node attributeNode = node.getAttributes().getNamedItem(attributeName);
        if (attributeNode == null) {
            return null;
        }
        return attributeNode.getNodeValue();
    }

    public static XmlService instance() {
        return (XmlService)Component.getInstance(XmlService.class);
    }
}

