/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import org.gluu.site.ldap.persistence.util.ReflectHelper;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.xdi.exception.PythonException;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.APPLICATION)
@Name(value="pythonService")
@AutoCreate
public class PythonService
implements Serializable {
    private static final long serialVersionUID = 3398422090669045605L;
    @Logger
    private Log log;
    private PythonInterpreter pythonInterpreter;
    private boolean interpereterReady;

    public boolean initPythonInterpreter() {
        boolean result = false;
        if (this.isInitInterpreter()) {
            try {
                PythonInterpreter.initialize((Properties)this.getPreProperties(), (Properties)this.getPostProperties(), null);
                this.pythonInterpreter = new PythonInterpreter();
                this.pythonInterpreter.setOut((OutputStream)new PythonLoggerOutputStream(this.log, false));
                this.pythonInterpreter.setErr((OutputStream)new PythonLoggerOutputStream(this.log, true));
                result = true;
            }
            catch (PyException ex) {
                this.log.error((Object)"Failed to initialize PythonInterpreter correctly", (Throwable)ex, new Object[0]);
            }
            catch (Exception ex) {
                this.log.error((Object)"Failed to initialize PythonInterpreter correctly", (Throwable)ex, new Object[0]);
            }
        }
        this.interpereterReady = result;
        return result;
    }

    @Destroy
    public void destroy() {
        this.log.debug((Object)"Destroying pythonInterpreter component", new Object[0]);
        if (this.pythonInterpreter != null) {
            this.pythonInterpreter.cleanup();
        }
    }

    private Properties getPreProperties() {
        Properties props = System.getProperties();
        Properties clonedProps = (Properties)props.clone();
        clonedProps.setProperty("java.class.path", ".");
        clonedProps.setProperty("java.library.path", "");
        clonedProps.remove("javax.net.ssl.trustStore");
        clonedProps.remove("javax.net.ssl.trustStorePassword");
        return clonedProps;
    }

    private Properties getPostProperties() {
        Properties props = this.getPreProperties();
        String catalinaTmpFolder = System.getProperty("java.io.tmpdir") + File.separator + "python" + File.separator + "cachedir";
        props.setProperty("python.cachedir", catalinaTmpFolder);
        String pythonHome = System.getenv("PYTHON_HOME");
        if (StringHelper.isNotEmpty((String)pythonHome)) {
            props.setProperty("python.home", pythonHome);
        }
        String oxAuthPythonModulesPath = System.getProperty("catalina.home") + File.separator + "conf" + File.separator + "python";
        props.setProperty("python.path", oxAuthPythonModulesPath);
        return props;
    }

    private boolean isInitInterpreter() {
        String pythonHome = System.getenv("PYTHON_HOME");
        return StringHelper.isNotEmpty((String)pythonHome);
    }

    public <T> T loadPythonScript(String scriptName, String scriptPythonType, Class<T> scriptJavaType, PyObject[] constructorArgs) throws PythonException {
        if (!this.interpereterReady || StringHelper.isEmpty((String)scriptName)) {
            return null;
        }
        PythonInterpreter currentPythonInterpreter = PythonInterpreter.threadLocalStateInterpreter(null);
        try {
            currentPythonInterpreter.execfile(scriptName);
        }
        catch (Exception ex) {
            throw new PythonException(String.format("Failed to load python file '%s'", scriptName), ex);
        }
        return this.loadPythonScript(scriptPythonType, scriptJavaType, constructorArgs, currentPythonInterpreter);
    }

    public <T> T loadPythonScript(InputStream scriptFile, String scriptPythonType, Class<T> scriptJavaType, PyObject[] constructorArgs) throws PythonException {
        if (!this.interpereterReady || scriptFile == null) {
            return null;
        }
        PythonInterpreter currentPythonInterpreter = PythonInterpreter.threadLocalStateInterpreter(null);
        try {
            currentPythonInterpreter.execfile(scriptFile);
        }
        catch (Exception ex) {
            throw new PythonException(String.format("Failed to load python file '%s'", scriptFile), ex);
        }
        return this.loadPythonScript(scriptPythonType, scriptJavaType, constructorArgs, currentPythonInterpreter);
    }

    private <T> T loadPythonScript(String scriptPythonType, Class<T> scriptJavaType, PyObject[] constructorArgs, PythonInterpreter interpreter) throws PythonException {
        PyObject scriptPythonTypeClass;
        PyObject scriptPythonTypeObject = interpreter.get(scriptPythonType);
        if (scriptPythonTypeObject == null) {
            return null;
        }
        try {
            scriptPythonTypeClass = scriptPythonTypeObject.__call__(constructorArgs);
        }
        catch (Exception ex) {
            throw new PythonException(String.format("Failed to initialize python class '%s'", scriptPythonType), ex);
        }
        Object scriptJavaClass = scriptPythonTypeClass.__tojava__(scriptJavaType);
        if (!ReflectHelper.assignableFrom(scriptJavaClass.getClass(), scriptJavaType)) {
            return null;
        }
        return (T)scriptJavaClass;
    }

    public static PythonService instance() {
        return (PythonService)Component.getInstance(PythonService.class);
    }

    class PythonLoggerOutputStream
    extends OutputStream {
        private boolean error;
        private Log log;
        private StringBuffer buffer;

        private PythonLoggerOutputStream(Log log, boolean error) {
            this.error = error;
            this.log = log;
            this.buffer = new StringBuffer();
        }

        @Override
        public void write(int b) throws IOException {
            if ((char)b == '\n' || (char)b == '\r') {
                this.flush();
            } else {
                this.buffer.append((char)b);
            }
        }

        @Override
        public void flush() {
            if (this.buffer.length() > 0) {
                if (this.error) {
                    this.log.error((Object)this.buffer.toString(), new Object[0]);
                } else {
                    this.log.info((Object)this.buffer.toString(), new Object[0]);
                }
                this.buffer.setLength(0);
            }
        }
    }
}

