/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SerializationUtils;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;

@Name(value="objectSerializationService")
@Scope(value=ScopeType.APPLICATION)
@AutoCreate
public class ObjectSerializationService {
    @Logger
    private Log log;

    public boolean saveObject(String path, Serializable obj, boolean append) {
        FileOutputStream fos;
        File file = new File(path);
        try {
            fos = new FileOutputStream(file, append);
        }
        catch (FileNotFoundException ex) {
            this.log.error((Object)"Faield to serialize to file: '{0}'. Error: ", new Object[]{path, ex});
            return false;
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            GZIPOutputStream gos = new GZIPOutputStream(bos);
            SerializationUtils.serialize((Serializable)obj, (OutputStream)gos);
            gos.flush();
            IOUtils.closeQuietly((OutputStream)gos);
        }
        catch (IOException ex) {
            this.log.error((Object)"Faield to serialize to file: '{0}'. Error: ", new Object[]{path, ex});
            IOUtils.closeQuietly((OutputStream)bos);
            return false;
        }
        return true;
    }

    public boolean saveObject(String path, Serializable obj) {
        return this.saveObject(path, obj, false);
    }

    public Object loadObject(String path) {
        FileInputStream fis;
        File file = new File(path);
        if (!file.exists()) {
            this.log.trace((Object)"File '{0}' is not exist", new Object[]{path});
            return null;
        }
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            this.log.error((Object)"Faield to deserialize from file: '{0}'. Error: ", new Object[]{path, ex});
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        Object obj = null;
        try {
            GZIPInputStream gis = new GZIPInputStream(bis);
            obj = SerializationUtils.deserialize((InputStream)gis);
            IOUtils.closeQuietly((InputStream)gis);
        }
        catch (IOException ex) {
            this.log.error((Object)"Faield to deserialize from file: '{0}'. Error: ", new Object[]{path, ex});
            IOUtils.closeQuietly((InputStream)bis);
            return null;
        }
        return obj;
    }

    public void cleanup(String path) {
        File file = new File(path);
        FileUtils.deleteQuietly((File)file);
    }

    public static ObjectSerializationService instance() {
        return (ObjectSerializationService)Component.getInstance(ObjectSerializationService.class);
    }
}

