/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.model.SmtpConfiguration;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.APPLICATION)
@Name(value="mailService")
@AutoCreate
public class MailService {
    @Logger
    private Log log;
    @In(required=false)
    private SmtpConfiguration smtpConfiguration;
    private long connectionTimeout = 5000L;

    public boolean sendMail(String to, String subject, String message) {
        return this.sendMail(this.smtpConfiguration, null, to, subject, message);
    }

    public boolean sendMail(String from, String to, String subject, String message) {
        return this.sendMail(this.smtpConfiguration, from, to, subject, message);
    }

    public boolean sendMail(SmtpConfiguration mailSmtpConfiguration, String from, String to, String subject, String message) {
        if (mailSmtpConfiguration == null) {
            this.log.error((Object)"Failed to send message from '{0}' to '{1}' because the SMTP configuration isn't valid!", new Object[]{from, to});
            return false;
        }
        this.log.debug((Object)("Host name: " + mailSmtpConfiguration.getHost() + ", port: " + mailSmtpConfiguration.getPort() + ", connection time out: " + this.connectionTimeout), new Object[0]);
        String mailFrom = from;
        if (StringHelper.isEmpty((String)mailFrom)) {
            mailFrom = mailSmtpConfiguration.getFromEmailAddress();
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", mailSmtpConfiguration.getHost());
        props.put("mail.smtp.port", (Object)mailSmtpConfiguration.getPort());
        props.put("mail.from", mailFrom);
        props.put("mail.smtp.connectiontimeout", (Object)this.connectionTimeout);
        props.put("mail.smtp.timeout", (Object)this.connectionTimeout);
        if (mailSmtpConfiguration.isRequiresSsl()) {
            props.put("mail.smtp.socketFactory.port", (Object)mailSmtpConfiguration.getPort());
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        Session session = null;
        if (mailSmtpConfiguration.isRequiresAuthentication()) {
            props.put("mail.smtp.auth", "true");
            final String userName = mailSmtpConfiguration.getUserName();
            final String password = mailSmtpConfiguration.getPasswordDecrypted();
            session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(userName, password);
                }
            });
        } else {
            Session.getInstance((Properties)props, null);
        }
        MimeMessage msg = new MimeMessage(session);
        try {
            msg.setFrom((Address)new InternetAddress(mailFrom));
            msg.setRecipients(Message.RecipientType.TO, to);
            msg.setSubject(subject, "UTF-8");
            msg.setSentDate(new Date());
            msg.setText(message + "\n", "UTF-8");
            Transport.send((Message)msg);
        }
        catch (MessagingException ex) {
            this.log.error((Object)"Failed to send message", (Throwable)ex, new Object[0]);
            return false;
        }
        return true;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public static MailService instance() {
        return (MailService)Component.getInstance(MailService.class);
    }
}

