/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service;

import com.unboundid.ldap.sdk.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.ldap.model.Entry;
import org.xdi.model.DisplayNameEntry;
import org.xdi.service.CacheService;

@Scope(value=ScopeType.STATELESS)
@Name(value="lookupService")
@AutoCreate
public class LookupService
implements Serializable {
    private static final long serialVersionUID = -3707238475653913313L;
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private CacheService cacheService;

    public DisplayNameEntry getDisplayNameEntry(String dn) throws Exception {
        String key = dn;
        DisplayNameEntry entry = (DisplayNameEntry)this.cacheService.get("LookupCache", key);
        if (entry == null) {
            entry = (DisplayNameEntry)this.ldapEntryManager.find(DisplayNameEntry.class, (Object)key);
            this.cacheService.put("LookupCache", key, entry);
        }
        return entry;
    }

    public List<DisplayNameEntry> getDisplayNameEntries(String baseDn, List<String> dns) {
        List<String> inums = this.getInumsFromDns(dns);
        if (inums.size() == 0) {
            return null;
        }
        String key = this.getCompoundKey(inums);
        List entries = (List)this.cacheService.get("LookupCache", key);
        if (entries == null) {
            Filter searchFilter = this.buildInumFilter(inums);
            entries = this.ldapEntryManager.findEntries(baseDn, DisplayNameEntry.class, searchFilter);
            this.cacheService.put("LookupCache", key, entries);
        }
        return entries;
    }

    public Filter buildInumFilter(List<String> inums) {
        ArrayList<Filter> inumFilters = new ArrayList<Filter>(inums.size());
        for (String inum : inums) {
            inumFilters.add(Filter.createEqualityFilter((String)"inum", (String)inum));
        }
        Filter searchFilter = Filter.createORFilter(inumFilters);
        return searchFilter;
    }

    public List<String> getInumsFromDns(List<String> dns) {
        ArrayList<String> inums = new ArrayList<String>();
        if (dns == null) {
            return inums;
        }
        for (String dn : dns) {
            String inum = this.getInumFromDn(dn);
            if (inum == null) continue;
            inums.add(inum);
        }
        Collections.sort(inums);
        return inums;
    }

    private String getCompoundKey(List<String> inums) {
        StringBuilder compoundKey = new StringBuilder();
        for (String inum : inums) {
            if (compoundKey.length() > 0) {
                compoundKey.append("_");
            }
            compoundKey.append(inum);
        }
        return compoundKey.toString();
    }

    public List<DisplayNameEntry> getDisplayNameEntriesByEntries(String baseDn, List<? extends Entry> entries) throws Exception {
        if (entries == null) {
            return null;
        }
        ArrayList<String> dns = new ArrayList<String>(entries.size());
        for (Entry entry : entries) {
            dns.add(entry.getDn());
        }
        return this.getDisplayNameEntries(baseDn, dns);
    }

    public String getInumFromDn(String dn) {
        if (dn == null) {
            return null;
        }
        if (!dn.startsWith("inum=")) {
            return null;
        }
        int idx = dn.indexOf(",", 5);
        if (idx == -1) {
            return null;
        }
        return dn.substring(5, idx);
    }

    public static LookupService instance() throws Exception {
        return (LookupService)Component.getInstance(LookupService.class);
    }
}

