/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;

@Name(value="jsonService")
@Scope(value=ScopeType.APPLICATION)
@AutoCreate
public class JsonService {
    @Logger
    private Log log;
    private ObjectMapper mapper;

    @Create
    public void init() {
        this.mapper = new ObjectMapper();
    }

    public <T> T jsonToObject(String json, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        return (T)this.mapper.readValue(json, clazz);
    }

    public <T> String objectToJson(T obj) throws JsonGenerationException, JsonMappingException, IOException {
        return this.mapper.writeValueAsString(obj);
    }

    public <T> String objectToPerttyJson(T obj) throws JsonGenerationException, JsonMappingException, IOException {
        return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    public static JsonService instance() {
        return (JsonService)Component.getInstance(JsonService.class);
    }
}

