/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.cache.CacheProvider;
import org.jboss.seam.log.Log;

@Scope(value=ScopeType.APPLICATION)
@Name(value="cacheService")
@AutoCreate
public class CacheService {
    @In(required=false)
    private CacheProvider<?> cacheProvider;
    @Logger
    private Log log;

    public Object get(String region, String key) {
        if (this.cacheProvider == null) {
            return null;
        }
        return this.cacheProvider.get(region, key);
    }

    public void put(String region, String key, Object object) {
        if (this.cacheProvider != null) {
            this.cacheProvider.put(region, key, object);
        }
    }

    public void remove(String region, String key) {
        if (this.cacheProvider == null) {
            return;
        }
        this.cacheProvider.remove(region, key);
    }

    public void removeAll(String name) {
        if (this.cacheProvider != null) {
            ((CacheManager)this.cacheProvider.getDelegate()).getCache(name).removeAll();
        }
    }

    public Cache getCacheRegion(String regionName) {
        CacheManager cacheManager;
        Cache cache = null;
        if (this.cacheProvider != null && (cache = (cacheManager = (CacheManager)this.cacheProvider.getDelegate()).getCache(regionName)) == null) {
            this.log.error((Object)("Could not find configuration for region [" + regionName + "]; using defaults."), new Object[0]);
        }
        return cache;
    }

    public static CacheService instance() {
        return (CacheService)Component.getInstance(CacheService.class);
    }
}

