/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import java.util.ArrayList;
import java.util.List;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.log.Log;
import org.xdi.model.GluuAttribute;
import org.xdi.model.SchemaEntry;
import org.xdi.service.CacheService;
import org.xdi.service.SchemaService;

public class AttributeService {
    @Logger
    protected Log log;
    @In
    protected LdapEntryManager ldapEntryManager;
    @In
    protected SchemaService schemaService;
    @In
    protected CacheService cacheService;

    public List<GluuAttribute> getAttributesByAttribute(String attributeName, String attributeValue, String baseDn) {
        String[] targetArray = new String[]{attributeValue};
        Filter filter = Filter.createSubstringFilter((String)attributeName, null, (String[])targetArray, null);
        List result = this.ldapEntryManager.findEntries(baseDn, GluuAttribute.class, filter);
        return result;
    }

    public String getDefaultSaml2Uri(String name) {
        SchemaEntry schemaEntry = this.schemaService.getSchema();
        ArrayList<String> attributeNames = new ArrayList<String>();
        attributeNames.add(name);
        List<AttributeTypeDefinition> attributeTypes = this.schemaService.getAttributeTypeDefinitions(schemaEntry, attributeNames);
        AttributeTypeDefinition attributeTypeDefinition = this.schemaService.getAttributeTypeDefinition(attributeTypes, name);
        return String.format("urn:oid:%s", attributeTypeDefinition.getOID());
    }

    public List<GluuAttribute> getAllAttributes(String baseDn) {
        List<GluuAttribute> attributeList = (List<GluuAttribute>)this.cacheService.get("AttributeCache", "attributeList");
        if (attributeList == null) {
            attributeList = this.getAllAtributesImpl(baseDn);
            this.cacheService.put("AttributeCache", "attributeList", attributeList);
        }
        return attributeList;
    }

    protected List<GluuAttribute> getAllAtributesImpl(String baseDn) {
        List attributeList = this.ldapEntryManager.findEntries(baseDn, GluuAttribute.class, null);
        return attributeList;
    }
}

