/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.model.custom.script.model;

import java.util.Iterator;
import java.util.List;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapJsonObject;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.ldap.model.BaseEntry;
import org.xdi.model.ProgrammingLanguage;
import org.xdi.model.ScriptLocationType;
import org.xdi.model.SimpleCustomProperty;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.util.StringHelper;

@LdapEntry(sortBy={"level"})
@LdapObjectClass(values={"top", "oxCustomScript"})
public class CustomScript
extends BaseEntry {
    public static final String LOCATION_TYPE_MODEL_PROPERTY = "location_type";
    public static final String LOCATION_PATH_MODEL_PROPERTY = "location_path";
    @LdapAttribute(ignoreDuringUpdate=true)
    private String inum;
    @Pattern(regexp="^[a-zA-Z0-9_]+$", message="Name should contain only letters, digits and underscores")
    @NotNull(message="Name should be not empty")
    @LdapAttribute(name="displayName")
    private String name;
    @LdapAttribute(name="description")
    private String description;
    @LdapAttribute(name="oxScript")
    private String script;
    @LdapAttribute(name="oxScriptType")
    private CustomScriptType scriptType;
    @LdapAttribute(name="programmingLanguage")
    private ProgrammingLanguage programmingLanguage;
    @LdapJsonObject
    @LdapAttribute(name="oxModuleProperty")
    private List<SimpleCustomProperty> moduleProperties;
    @LdapJsonObject
    @LdapAttribute(name="oxConfigurationProperty")
    private List<SimpleCustomProperty> configurationProperties;
    @LdapAttribute(name="oxLevel")
    private int level;
    @LdapAttribute(name="oxRevision")
    private long revision;
    @LdapAttribute(name="gluuStatus")
    private boolean enabled;
    @Transient
    private boolean modified;

    public CustomScript() {
    }

    public CustomScript(String dn, String inum, String name) {
        super(dn);
        this.inum = inum;
        this.name = name;
    }

    public CustomScript(CustomScript customScript) {
        super(customScript.getDn());
        this.inum = customScript.inum;
        this.name = customScript.name;
        this.description = customScript.description;
        this.script = customScript.script;
        this.scriptType = customScript.scriptType;
        this.programmingLanguage = customScript.programmingLanguage;
        this.moduleProperties = customScript.moduleProperties;
        this.configurationProperties = customScript.configurationProperties;
        this.level = customScript.level;
        this.revision = customScript.revision;
        this.enabled = customScript.enabled;
        this.modified = customScript.modified;
    }

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public CustomScriptType getScriptType() {
        return this.scriptType;
    }

    public void setScriptType(CustomScriptType scriptType) {
        this.scriptType = scriptType;
    }

    public ProgrammingLanguage getProgrammingLanguage() {
        return this.programmingLanguage;
    }

    public void setProgrammingLanguage(ProgrammingLanguage programmingLanguage) {
        this.programmingLanguage = programmingLanguage;
    }

    public List<SimpleCustomProperty> getModuleProperties() {
        return this.moduleProperties;
    }

    public void setModuleProperties(List<SimpleCustomProperty> moduleProperties) {
        this.moduleProperties = moduleProperties;
    }

    public List<SimpleCustomProperty> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(List<SimpleCustomProperty> properties) {
        this.configurationProperties = properties;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public ScriptLocationType getLocationType() {
        SimpleCustomProperty moduleProperty = this.getModuleProperty(LOCATION_TYPE_MODEL_PROPERTY);
        if (moduleProperty == null) {
            return null;
        }
        return ScriptLocationType.getByValue((String)moduleProperty.getValue2());
    }

    public void setLocationType(ScriptLocationType locationType) {
        if (locationType != null) {
            this.setModuleProperty(LOCATION_TYPE_MODEL_PROPERTY, locationType.getValue());
        }
    }

    public String getLocationPath() {
        SimpleCustomProperty moduleProperty = this.getModuleProperty(LOCATION_PATH_MODEL_PROPERTY);
        if (moduleProperty == null) {
            return null;
        }
        return moduleProperty.getValue2();
    }

    public void setLocationPath(String locationPath) {
        this.setModuleProperty(LOCATION_PATH_MODEL_PROPERTY, locationPath);
    }

    protected SimpleCustomProperty getModuleProperty(String modulePropertyName) {
        SimpleCustomProperty result = null;
        List<SimpleCustomProperty> moduleProperties = this.getModuleProperties();
        if (moduleProperties == null) {
            return result;
        }
        for (SimpleCustomProperty moduleProperty : this.getModuleProperties()) {
            if (!StringHelper.equalsIgnoreCase((String)moduleProperty.getValue1(), (String)modulePropertyName)) continue;
            result = moduleProperty;
            break;
        }
        return result;
    }

    protected void setModuleProperty(String name, String value) {
        SimpleCustomProperty moduleProperty = this.getModuleProperty(name);
        if (moduleProperty == null) {
            this.addModuleProperty(name, value);
        } else {
            moduleProperty.setValue2(value);
        }
    }

    public void addModuleProperty(String name, String value) {
        SimpleCustomProperty usageTypeModuleProperties = new SimpleCustomProperty(name, value);
        this.getModuleProperties().add(usageTypeModuleProperties);
    }

    public void removeModuleProperty(String modulePropertyName) {
        List<SimpleCustomProperty> moduleProperties = this.getModuleProperties();
        if (moduleProperties == null) {
            return;
        }
        Iterator<SimpleCustomProperty> it = moduleProperties.iterator();
        while (it.hasNext()) {
            SimpleCustomProperty moduleProperty = it.next();
            if (!StringHelper.equalsIgnoreCase((String)moduleProperty.getValue1(), (String)modulePropertyName)) continue;
            it.remove();
            break;
        }
    }
}

