/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.model.custom.script;

import java.util.HashMap;
import java.util.Map;
import org.gluu.site.ldap.persistence.annotation.LdapEnum;
import org.xdi.model.custom.script.model.CustomScript;
import org.xdi.model.custom.script.model.auth.AuthenticationCustomScript;
import org.xdi.model.custom.script.type.BaseExternalType;
import org.xdi.model.custom.script.type.auth.DummyPersonAuthenticationType;
import org.xdi.model.custom.script.type.auth.PersonAuthenticationType;
import org.xdi.model.custom.script.type.client.ClientRegistrationType;
import org.xdi.model.custom.script.type.client.DummyClientRegistrationType;
import org.xdi.model.custom.script.type.id.DummyIdGeneratorType;
import org.xdi.model.custom.script.type.id.IdGeneratorType;
import org.xdi.model.custom.script.type.scim.DummyScimType;
import org.xdi.model.custom.script.type.scim.ScimType;
import org.xdi.model.custom.script.type.scope.DummyDynamicScopeType;
import org.xdi.model.custom.script.type.scope.DynamicScopeType;
import org.xdi.model.custom.script.type.session.ApplicationSessionType;
import org.xdi.model.custom.script.type.session.DummyApplicationSessionType;
import org.xdi.model.custom.script.type.uma.AuthorizationPolicyType;
import org.xdi.model.custom.script.type.uma.DummyAuthorizationPolicyType;
import org.xdi.model.custom.script.type.user.CacheRefreshType;
import org.xdi.model.custom.script.type.user.DummyCacheRefreshType;
import org.xdi.model.custom.script.type.user.DummyUpdateUserType;
import org.xdi.model.custom.script.type.user.DummyUserRegistrationType;
import org.xdi.model.custom.script.type.user.UpdateUserType;
import org.xdi.model.custom.script.type.user.UserRegistrationType;

public enum CustomScriptType implements LdapEnum
{
    PERSON_AUTHENTICATION("person_authentication", "Person Authentication", PersonAuthenticationType.class, AuthenticationCustomScript.class, "PersonAuthentication", new DummyPersonAuthenticationType()),
    APPLICATION_SESSION("application_session", "Application Session", ApplicationSessionType.class, CustomScript.class, "ApplicationSession", new DummyApplicationSessionType()),
    CACHE_REFRESH("cache_refresh", "Cache Refresh", CacheRefreshType.class, CustomScript.class, "CacheRefresh", new DummyCacheRefreshType()),
    UPDATE_USER("update_user", "Update User", UpdateUserType.class, CustomScript.class, "UpdateUser", new DummyUpdateUserType()),
    USER_REGISTRATION("user_registration", "User Registration", UserRegistrationType.class, CustomScript.class, "UserRegistration", new DummyUserRegistrationType()),
    CLIENT_REGISTRATION("client_registration", "Client Registration", ClientRegistrationType.class, CustomScript.class, "ClientRegistration", new DummyClientRegistrationType()),
    ID_GENERATOR("id_generator", "Id Generator", IdGeneratorType.class, CustomScript.class, "IdGenerator", new DummyIdGeneratorType()),
    UMA_AUTHORIZATION_POLICY("uma_authorization_policy", "UMA Authorization Policies", AuthorizationPolicyType.class, CustomScript.class, "AuthorizationPolicy", new DummyAuthorizationPolicyType()),
    DYNAMIC_SCOPE("dynamic_scope", "Dynamic Scopes", DynamicScopeType.class, CustomScript.class, "DynamicScope", new DummyDynamicScopeType()),
    SCIM("scim", "SCIM", ScimType.class, CustomScript.class, "ScimEventHandler", new DummyScimType());

    private String value;
    private String displayName;
    private Class<? extends BaseExternalType> customScriptType;
    private Class<? extends CustomScript> customScriptModel;
    private String pythonClass;
    private BaseExternalType defaultImplementation;
    private static Map<String, CustomScriptType> mapByValues;

    private CustomScriptType(String value, String displayName, Class<? extends BaseExternalType> customScriptType, Class<? extends CustomScript> customScriptModel, String pythonClass, BaseExternalType defaultImplementation) {
        this.displayName = displayName;
        this.value = value;
        this.customScriptType = customScriptType;
        this.customScriptModel = customScriptModel;
        this.pythonClass = pythonClass;
        this.defaultImplementation = defaultImplementation;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public Class<? extends BaseExternalType> getCustomScriptType() {
        return this.customScriptType;
    }

    public Class<? extends CustomScript> getCustomScriptModel() {
        return this.customScriptModel;
    }

    public String getPythonClass() {
        return this.pythonClass;
    }

    public BaseExternalType getDefaultImplementation() {
        return this.defaultImplementation;
    }

    public static CustomScriptType getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends LdapEnum> resolveByValue(String value) {
        return CustomScriptType.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, CustomScriptType>();
        for (CustomScriptType enumType : CustomScriptType.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

