/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Matcher;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapJsonObject;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.ldap.model.Entry;
import org.xdi.ldap.model.GluuStatus;
import org.xdi.model.AttributeValidation;
import org.xdi.model.GluuAttributeDataType;
import org.xdi.model.GluuAttributeUsageType;
import org.xdi.model.GluuUserRole;
import org.xdi.model.OxMultivalued;
import org.xdi.model.ScimCustomAtribute;

@LdapEntry(sortBy={"displayName"})
@LdapObjectClass(values={"top", "gluuAttribute"})
public class GluuAttribute
extends Entry
implements Serializable {
    private static final long serialVersionUID = 4817004894646725606L;
    private transient boolean selected;
    @LdapAttribute(ignoreDuringUpdate=true)
    private String inum;
    @LdapAttribute(name="oxAttributeType")
    private String type;
    @LdapAttribute
    private String lifetime;
    @LdapAttribute(name="oxSourceAttribute")
    private String sourceAttribute;
    @LdapAttribute
    private String salt;
    @LdapAttribute(name="oxNameIdType")
    private String nameIdType;
    @NotNull
    @Pattern(regexp="^[a-zA-Z_]+$", message="Name should contain only letters and underscores")
    @Size(min=1, max=30, message="Length of the Name should be between 1 and 30")
    @LdapAttribute(name="gluuAttributeName")
    private String name;
    @NotNull
    @Size(min=0, max=60, message="Length of the Display Name should not exceed 60")
    @LdapAttribute
    private String displayName;
    @NotNull
    @Size(min=0, max=4000, message="Length of the Description should not exceed 4000")
    @LdapAttribute
    private String description;
    @LdapAttribute(name="gluuAttributeOrigin")
    private String origin;
    @NotNull
    @LdapAttribute(name="gluuAttributeType")
    private GluuAttributeDataType dataType;
    @NotNull
    @LdapAttribute(name="gluuAttributeEditType")
    private GluuUserRole[] editType;
    @NotNull
    @LdapAttribute(name="gluuAttributeViewType")
    private GluuUserRole[] viewType;
    @LdapAttribute(name="gluuAttributeUsageType")
    private GluuAttributeUsageType[] usageType;
    @LdapAttribute(name="oxAuthClaimName")
    private String oxAuthClaimName;
    @LdapAttribute(name="seeAlso")
    private String seeAlso;
    @LdapAttribute(name="gluuStatus")
    private GluuStatus status;
    @LdapAttribute(name="gluuSAML1URI")
    private String saml1Uri;
    @LdapAttribute(name="gluuSAML2URI")
    private String saml2Uri;
    @LdapAttribute(ignoreDuringUpdate=true)
    private String urn;
    @LdapAttribute(name="oxSCIMCustomAttribute")
    private ScimCustomAtribute oxSCIMCustomAttribute;
    @LdapAttribute(name="oxMultivaluedAttribute")
    private OxMultivalued oxMultivaluedAttribute;
    @Transient
    private boolean custom;
    @Transient
    private boolean requred;
    @LdapAttribute(name="gluuRegExp")
    private String regExp;
    @LdapJsonObject
    @LdapAttribute(name="oxValidation")
    private AttributeValidation attributeValidation;
    @LdapAttribute(name="gluuTooltip")
    private String gluuTooltip;

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(String lifetime) {
        this.lifetime = lifetime;
    }

    public String getSourceAttribute() {
        return this.sourceAttribute;
    }

    public void setSourceAttribute(String sourceAttribute) {
        this.sourceAttribute = sourceAttribute;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getNameIdType() {
        return this.nameIdType;
    }

    public void setNameIdType(String nameIdType) {
        this.nameIdType = nameIdType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public GluuAttributeDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(GluuAttributeDataType dataType) {
        this.dataType = dataType;
    }

    public GluuUserRole[] getEditType() {
        return this.editType;
    }

    public void setEditType(GluuUserRole[] editType) {
        this.editType = editType;
    }

    public GluuUserRole[] getViewType() {
        return this.viewType;
    }

    public void setViewType(GluuUserRole[] viewType) {
        this.viewType = viewType;
    }

    public GluuAttributeUsageType[] getUsageType() {
        return this.usageType;
    }

    public void setUsageType(GluuAttributeUsageType[] usageType) {
        this.usageType = usageType;
    }

    public String getOxAuthClaimName() {
        return this.oxAuthClaimName;
    }

    public void setOxAuthClaimName(String oxAuthClaimName) {
        this.oxAuthClaimName = oxAuthClaimName;
    }

    public String getSeeAlso() {
        return this.seeAlso;
    }

    public void setSeeAlso(String seeAlso) {
        this.seeAlso = seeAlso;
    }

    public GluuStatus getStatus() {
        return this.status;
    }

    public void setStatus(GluuStatus status) {
        this.status = status;
    }

    public String getSaml1Uri() {
        return this.saml1Uri;
    }

    public void setSaml1Uri(String saml1Uri) {
        this.saml1Uri = saml1Uri;
    }

    public String getSaml2Uri() {
        return this.saml2Uri;
    }

    public void setSaml2Uri(String saml2Uri) {
        this.saml2Uri = saml2Uri;
    }

    public String getUrn() {
        return this.urn;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public ScimCustomAtribute getOxSCIMCustomAttribute() {
        return this.oxSCIMCustomAttribute;
    }

    public void setOxSCIMCustomAttribute(ScimCustomAtribute oxSCIMCustomAttribute) {
        this.oxSCIMCustomAttribute = oxSCIMCustomAttribute;
    }

    public OxMultivalued getOxMultivaluedAttribute() {
        return this.oxMultivaluedAttribute;
    }

    public void setOxMultivaluedAttribute(OxMultivalued oxMultivaluedAttribute) {
        this.oxMultivaluedAttribute = oxMultivaluedAttribute;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public boolean isRequred() {
        return this.requred;
    }

    public void setRequred(boolean requred) {
        this.requred = requred;
    }

    public String getRegExp() {
        return this.regExp;
    }

    public void setRegExp(String regExp) {
        this.regExp = regExp;
    }

    public String getGluuTooltip() {
        return this.gluuTooltip;
    }

    public void setGluuTooltip(String gluuTooltip) {
        this.gluuTooltip = gluuTooltip;
    }

    public boolean allowEditBy(GluuUserRole role) {
        return GluuUserRole.containsRole(this.editType, role);
    }

    public boolean allowViewBy(GluuUserRole role) {
        return GluuUserRole.containsRole(this.viewType, role);
    }

    public boolean isAdminCanAccess() {
        return this.isAdminCanView() | this.isAdminCanEdit();
    }

    public boolean isAdminCanView() {
        return this.allowViewBy(GluuUserRole.ADMIN);
    }

    public boolean isAdminCanEdit() {
        return this.allowEditBy(GluuUserRole.ADMIN);
    }

    public boolean isUserCanAccess() {
        return this.isUserCanView() | this.isUserCanEdit();
    }

    public boolean isUserCanView() {
        return this.allowViewBy(GluuUserRole.USER);
    }

    public boolean isWhitePagesCanView() {
        return this.allowViewBy(GluuUserRole.WHITEPAGES);
    }

    public boolean isUserCanEdit() {
        return this.allowEditBy(GluuUserRole.USER);
    }

    public AttributeValidation getAttributeValidation() {
        return this.attributeValidation;
    }

    public void setAttributeValidation(AttributeValidation attributeValidation) {
        this.attributeValidation = attributeValidation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.custom ? 1231 : 1237);
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.editType);
        result = 31 * result + (this.gluuTooltip == null ? 0 : this.gluuTooltip.hashCode());
        result = 31 * result + (this.inum == null ? 0 : this.inum.hashCode());
        result = 31 * result + (this.lifetime == null ? 0 : this.lifetime.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nameIdType == null ? 0 : this.nameIdType.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.oxAuthClaimName == null ? 0 : this.oxAuthClaimName.hashCode());
        result = 31 * result + (this.oxMultivaluedAttribute == null ? 0 : this.oxMultivaluedAttribute.hashCode());
        result = 31 * result + (this.oxSCIMCustomAttribute == null ? 0 : this.oxSCIMCustomAttribute.hashCode());
        result = 31 * result + (this.regExp == null ? 0 : this.regExp.hashCode());
        result = 31 * result + (this.requred ? 1231 : 1237);
        result = 31 * result + (this.salt == null ? 0 : this.salt.hashCode());
        result = 31 * result + (this.saml1Uri == null ? 0 : this.saml1Uri.hashCode());
        result = 31 * result + (this.saml2Uri == null ? 0 : this.saml2Uri.hashCode());
        result = 31 * result + (this.seeAlso == null ? 0 : this.seeAlso.hashCode());
        result = 31 * result + (this.sourceAttribute == null ? 0 : this.sourceAttribute.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.urn == null ? 0 : this.urn.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.usageType);
        result = 31 * result + Arrays.hashCode((Object[])this.viewType);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GluuAttribute)) {
            return false;
        }
        GluuAttribute other = (GluuAttribute)obj;
        if (this.inum == null ? other.inum != null : !this.inum.equals(other.inum)) {
            return false;
        }
        if (this.custom != other.custom) {
            return false;
        }
        if (this.dataType != other.dataType) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }

    public void validateAttribute(FacesContext context, UIComponent comp, Object value) {
        FacesMessage message;
        Integer minvalue = this.attributeValidation != null ? this.attributeValidation.getMinLength() : null;
        Integer maxValue = this.attributeValidation != null ? this.attributeValidation.getMaxLength() : null;
        String regexpValue = this.attributeValidation != null ? this.attributeValidation.getRegexp() : null;
        String attribute = (String)value;
        if (minvalue != null) {
            int min = this.attributeValidation.getMinLength();
            if (attribute != null && attribute.length() < min) {
                ((UIInput)comp).setValid(false);
                message = new FacesMessage(this.displayName + " should be at least " + min + " symbols. ");
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(comp.getClientId(context), message);
            }
        }
        if (maxValue != null) {
            int max = this.attributeValidation.getMaxLength();
            if (attribute != null && attribute.length() > max) {
                ((UIInput)comp).setValid(false);
                message = new FacesMessage(this.displayName + " should not exceed " + max + " symbols. ");
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(comp.getClientId(context), message);
            }
        }
        if (regexpValue != null && !regexpValue.trim().equals("")) {
            Matcher matcher;
            boolean flag;
            java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(regexpValue);
            if (attribute != null && !attribute.trim().equals("") && !(flag = (matcher = pattern.matcher(attribute)).matches())) {
                ((UIInput)comp).setValid(false);
                FacesMessage message2 = new FacesMessage(this.displayName + " Format is invalid. ");
                message2.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(comp.getClientId(context), message2);
            }
        }
    }
}

