/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxserver.filters;

import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;

public class CorsFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(CorsFilter.class);
    private static final String[] CORS_FILTERS = new String[]{"org.apache.catalina.filters.CorsFilter", "org.eclipse.jetty.servlets.CrossOriginFilter"};
    Filter filter;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filter = this.getServerCorsFilter();
        if (this.filter != null) {
            this.filter.init(filterConfig);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.filter != null) {
            this.filter.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        if (this.filter != null) {
            this.filter.destroy();
        }
    }

    public Filter getServerCorsFilter() {
        Filter resultFilter = null;
        for (String filterName : CORS_FILTERS) {
            try {
                Class<?> clazz = Class.forName(filterName);
                Constructor<?> cons = clazz.getDeclaredConstructor(new Class[0]);
                resultFilter = (Filter)cons.newInstance(new Object[0]);
                break;
            }
            catch (Exception ex) {
            }
        }
        if (resultFilter == null) {
            LOG.error((Object)"Failed to prepare CORS filter");
        } else {
            LOG.debug((Object)("Prepared CORS filter: " + resultFilter));
        }
        return resultFilter;
    }
}

