package org.ox.oxprox.model.ws;

import com.google.common.collect.Maps;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.type.TypeReference;
import org.ox.oxprox.Utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 08/05/2014
 */

public class ClientMapping {

    public static class Client implements Serializable {

        @JsonProperty(value = "id")
        private String id;
        @JsonProperty(value = "secret")
        private String secret;

        public Client() {
        }

        public Client(String id, String secret) {
            this.id = id;
            this.secret = secret;
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getSecret() {
            return secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }
    }

    private final Map<String, Client> map = Maps.newHashMap();

    public ClientMapping() {
    }

    public Map<String, Client> getMap() {
        return map;
    }

    public String asJson() throws IOException {
        return Utils.asJson(getMap());
    }

    public static ClientMapping parse(String json) throws IOException {
        TypeReference<HashMap<String, Client>> typeRef = new TypeReference<HashMap<String, Client>>() {
        };

        HashMap<String, Client> parsedMap = Utils.createJsonMapper().readValue(json, typeRef);
        final ClientMapping result = new ClientMapping();
        result.getMap().putAll(parsedMap);
        return result;
    }

    public static void main(String[] args) throws IOException {
        final ClientMapping mapping = new ClientMapping();
        mapping.getMap().put("example.com", new Client("1231233", "secret"));
        mapping.getMap().put("seed.gluu.org", new Client("@!1111!0008!FF81!2D40", "6213e9b9-c46d-4008-8af1-03f918a8ade4"));
        final String json = Utils.asJson(mapping.getMap());
        System.out.println(json);
        System.out.println(parse(json));
    }
}
