/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap.persistence;

import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;

public class LdapCustomAttribute
implements Serializable {
    private static final long serialVersionUID = 1468440094325406153L;
    private String propertyName;
    private String[] values;

    public LdapCustomAttribute() {
    }

    public LdapCustomAttribute(String propertyName, String value) {
        this.propertyName = propertyName;
        this.setValue(value);
    }

    public LdapCustomAttribute(String propertyName, String[] values) {
        this.propertyName = propertyName;
        this.values = values;
    }

    public String getValue() {
        if (this.values == null) {
            return null;
        }
        if (this.values.length > 0) {
            return this.values[0];
        }
        return null;
    }

    public void setValue(String value) {
        if (this.values == null) {
            this.values = new String[0];
        }
        if (this.values.length != 1) {
            this.values = new String[1];
        }
        this.values[0] = value;
    }

    public Date getDate() {
        if (this.values == null) {
            return null;
        }
        if (this.values.length > 0 && this.values[0] != null) {
            try {
                return StaticUtils.decodeGeneralizedTime((String)this.values[0]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(Date date) {
        if (this.values == null) {
            this.values = new String[0];
        }
        if (this.values.length != 1) {
            this.values = new String[1];
        }
        this.values[0] = StaticUtils.encodeGeneralizedTime((Date)date);
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getDisplayValue() {
        if (this.values == null) {
            return "";
        }
        if (this.values.length == 1) {
            return this.values[0];
        }
        StringBuilder sb = new StringBuilder(this.values[0]);
        for (int i = 1; i < this.values.length; ++i) {
            sb.append(", ").append(this.values[i]);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LdapCustomAttribute other = (LdapCustomAttribute)obj;
        return !(this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName));
    }

    public String toString() {
        return String.format("Attribute [propertyName=%s, values=%s]", this.propertyName, Arrays.toString(this.values));
    }
}

