/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap.persistence;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.codehaus.jackson.map.ObjectMapper;
import org.gluu.site.ldap.persistence.AttributeData;
import org.gluu.site.ldap.persistence.AttributeDataModification;
import org.gluu.site.ldap.persistence.PropertyAnnotation;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapAttributesList;
import org.gluu.site.ldap.persistence.annotation.LdapCustomObjectClass;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapEnum;
import org.gluu.site.ldap.persistence.annotation.LdapJsonObject;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.gluu.site.ldap.persistence.annotation.LdapSchemaEntry;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.gluu.site.ldap.persistence.exception.MappingException;
import org.gluu.site.ldap.persistence.property.Getter;
import org.gluu.site.ldap.persistence.property.Setter;
import org.gluu.site.ldap.persistence.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.util.ArrayHelper;
import org.xdi.util.StringHelper;

public abstract class AbstractEntryManager
implements EntityManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntryManager.class);
    private static final Class<?>[] LDAP_ENTRY_TYPE_ANNOTATIONS = new Class[]{LdapEntry.class, LdapSchemaEntry.class, LdapObjectClass.class};
    private static final Class<?>[] LDAP_ENTRY_PROPERTY_ANNOTATIONS = new Class[]{LdapAttribute.class, LdapAttributesList.class, LdapJsonObject.class};
    private static final Class<?>[] LDAP_CUSTOM_OBJECT_CLASS_PROPERTY_ANNOTATION = new Class[]{LdapCustomObjectClass.class};
    private static final Class<?>[] LDAP_DN_PROPERTY_ANNOTATION = new Class[]{LdapDN.class};
    public static final String OBJECT_CLASS = "objectClass";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Map<String, List<PropertyAnnotation>> classAnnotations = new HashMap<String, List<PropertyAnnotation>>();
    private final Map<String, Getter> classGetters = new HashMap<String, Getter>();
    private final Map<String, Setter> classSetters = new HashMap<String, Setter>();
    private static Object classAnnotationsLock = new Object();
    private static Object classSettersLock = new Object();
    private static Object classGettersLock = new Object();
    public static final String ATTRIBUTE_DN = "dn";
    private static final ObjectMapper jsonObjectMapper = new ObjectMapper();

    public void persist(Object entry) {
        if (entry == null) {
            throw new MappingException("Entry to persist is null");
        }
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getObjectClasses(entry, entryClass);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object dnValue = this.getDNValue(entry, entryClass);
        List<AttributeData> attributes = this.getAttributesListForPersist(entry, propertiesAnnotations);
        attributes.add(new AttributeData(OBJECT_CLASS, objectClasses));
        log.debug(String.format("LDAP attributes for persist: %s", attributes));
        this.persist(dnValue.toString(), attributes);
    }

    protected abstract void persist(String var1, List<AttributeData> var2);

    private <T> T merge(T entry, boolean isSchemaUpdate, AttributeDataModification.AttributeModificationType schemaModificationType) {
        List<AttributeData> attributesFromLdap;
        if (entry == null) {
            throw new MappingException("Entry to persist is null");
        }
        Class<?> entryClass = entry.getClass();
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object dnValue = this.getDNValue(entry, entryClass);
        List<AttributeData> attributesToPersist = this.getAttributesListForPersist(entry, propertiesAnnotations);
        Map<String, AttributeData> attributesToPersistMap = this.getAttributesMap(attributesToPersist);
        if (isSchemaUpdate) {
            attributesFromLdap = new ArrayList<AttributeData>();
        } else {
            List<String> currentLdapReturnAttributesList = this.getLdapAttributesList(entry, propertiesAnnotations, false);
            currentLdapReturnAttributesList.add(OBJECT_CLASS);
            attributesFromLdap = this.find(dnValue.toString(), currentLdapReturnAttributesList.toArray(EMPTY_STRING_ARRAY));
        }
        Map<String, AttributeData> attributesFromLdapMap = this.getAttributesMap(attributesFromLdap);
        ArrayList<AttributeDataModification> attributeDataModifications = new ArrayList<AttributeDataModification>();
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            String propertyName = propertiesAnnotation.getPropertyName();
            Annotation ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LdapAttribute.class);
            if (ldapAttribute == null) continue;
            String ldapAttributeName = ((LdapAttribute)ldapAttribute).name();
            if (StringHelper.isEmpty((String)ldapAttributeName)) {
                ldapAttributeName = propertyName;
            }
            ldapAttributeName = ldapAttributeName.toLowerCase();
            AttributeData attributeToPersist = attributesToPersistMap.get(ldapAttributeName);
            AttributeData attributeFromLdap = attributesFromLdapMap.get(ldapAttributeName);
            attributesToPersistMap.remove(ldapAttributeName);
            attributesFromLdapMap.remove(ldapAttributeName);
            LdapAttribute ldapAttributeAnnotation = (LdapAttribute)ldapAttribute;
            if (ldapAttributeAnnotation.ignoreDuringUpdate()) continue;
            if (attributeFromLdap != null && attributeToPersist != null) {
                if (attributeFromLdap.equals(attributeToPersist)) continue;
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REPLACE, attributeToPersist, attributeFromLdap));
                continue;
            }
            if (attributeFromLdap == null && attributeToPersist != null) {
                AttributeDataModification.AttributeModificationType modType;
                if (isSchemaUpdate && attributeToPersist.getValue() == null && Arrays.equals(attributeToPersist.getValues(), new String[0])) continue;
                AttributeDataModification.AttributeModificationType attributeModificationType = modType = isSchemaUpdate ? schemaModificationType : AttributeDataModification.AttributeModificationType.ADD;
                if (AttributeDataModification.AttributeModificationType.ADD.equals((Object)modType)) {
                    attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.ADD, attributeToPersist));
                    continue;
                }
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeToPersist));
                continue;
            }
            if (attributeFromLdap == null || attributeToPersist != null || ldapAttributeAnnotation.ignoreDuringRead() || ldapAttributeAnnotation.updateOnly()) continue;
            attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeFromLdap));
        }
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            LdapAttribute ldapAttributeConfiguration2;
            Annotation ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LdapAttributesList.class);
            if (ldapAttribute == null) continue;
            HashMap<String, LdapAttribute> ldapAttributesConfiguration = new HashMap<String, LdapAttribute>();
            for (LdapAttribute ldapAttributeConfiguration2 : ((LdapAttributesList)ldapAttribute).attributesConfiguration()) {
                ldapAttributesConfiguration.put(ldapAttributeConfiguration2.name(), ldapAttributeConfiguration2);
            }
            for (AttributeData attributeFromLdap : attributesFromLdapMap.values()) {
                String attributeName = attributeFromLdap.getName();
                if (OBJECT_CLASS.equalsIgnoreCase(attributeName) || (ldapAttributeConfiguration2 = (LdapAttribute)ldapAttributesConfiguration.get(attributeName)) != null && ldapAttributeConfiguration2.ignoreDuringUpdate() || attributesToPersistMap.containsKey(attributeName.toLowerCase()) || ldapAttributeConfiguration2 != null && (ldapAttributeConfiguration2 == null || ldapAttributeConfiguration2.ignoreDuringRead())) continue;
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeFromLdap));
            }
            for (AttributeData attributeToPersist : attributesToPersistMap.values()) {
                String attributeName = attributeToPersist.getName();
                ldapAttributeConfiguration2 = (LdapAttribute)ldapAttributesConfiguration.get(attributeName);
                if (ldapAttributeConfiguration2 != null && ldapAttributeConfiguration2.ignoreDuringUpdate()) continue;
                AttributeData attributeFromLdap = attributesFromLdapMap.get(attributeName.toLowerCase());
                if (attributeFromLdap == null) {
                    AttributeDataModification.AttributeModificationType modType;
                    AttributeDataModification.AttributeModificationType attributeModificationType = modType = isSchemaUpdate ? schemaModificationType : AttributeDataModification.AttributeModificationType.ADD;
                    if (AttributeDataModification.AttributeModificationType.ADD.equals((Object)modType)) {
                        Object[] attributeToPersistValues = attributeToPersist.getValues();
                        if (ArrayHelper.isEmpty((Object[])attributeToPersistValues) || attributeToPersistValues.length == 1 && StringHelper.isEmpty((String)attributeToPersistValues[0])) continue;
                        attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.ADD, attributeToPersist));
                        continue;
                    }
                    attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeToPersist));
                    continue;
                }
                if (attributeFromLdap != null && Arrays.equals(attributeToPersist.getValues(), new String[0])) {
                    attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeFromLdap));
                    continue;
                }
                if (attributeFromLdap.equals(attributeToPersist)) continue;
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REPLACE, attributeToPersist, attributeFromLdap));
            }
        }
        if (this.getSupportedLDAPVersion() > 2 && !isSchemaUpdate) {
            Object[] objectClasses = this.getObjectClasses(entry, entryClass);
            Object[] objectClassesFromLdap = attributesFromLdapMap.get(OBJECT_CLASS.toLowerCase()).getValues();
            if (!Arrays.equals(objectClassesFromLdap, objectClasses)) {
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REPLACE, new AttributeData(OBJECT_CLASS, (String[])objectClasses), new AttributeData(OBJECT_CLASS, (String[])objectClassesFromLdap)));
            }
        }
        log.debug(String.format("LDAP attributes for merge: %s", attributeDataModifications));
        this.merge(dnValue.toString(), attributeDataModifications);
        return (T)this.find(entryClass, (Object)dnValue.toString(), null, propertiesAnnotations);
    }

    public <T> T merge(T entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isLdapSchemaEntry(entryClass)) {
            if (this.getSupportedLDAPVersion() > 2) {
                return this.merge(entry, true, AttributeDataModification.AttributeModificationType.ADD);
            }
            throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
        }
        return this.merge(entry, false, null);
    }

    protected abstract void merge(String var1, List<AttributeDataModification> var2);

    public void remove(Object entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isLdapSchemaEntry(entryClass)) {
            if (this.getSupportedLDAPVersion() <= 2) {
                throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
            }
            this.merge(entry, true, AttributeDataModification.AttributeModificationType.REMOVE);
            return;
        }
        Object dnValue = this.getDNValue(entry, entryClass);
        log.debug(String.format("LDAP entry to remove: %s", dnValue.toString()));
        this.remove(dnValue.toString());
    }

    protected abstract void remove(String var1);

    protected abstract void removeWithSubtree(String var1);

    public boolean contains(Object entry) {
        if (entry == null) {
            throw new MappingException("Entry to persist is null");
        }
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getObjectClasses(entry, entryClass);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object dnValue = this.getDNValue(entry, entryClass);
        List<AttributeData> attributes = this.getAttributesListForPersist(entry, propertiesAnnotations);
        String[] ldapReturnAttributes = this.getLdapAttributes(null, propertiesAnnotations, false);
        return this.contains(dnValue.toString(), attributes, objectClasses, ldapReturnAttributes);
    }

    protected abstract boolean contains(String var1, List<AttributeData> var2, String[] var3, String ... var4);

    public <T> boolean contains(Class<T> entryClass, String primaryKey, String[] ldapReturnAttributes) {
        if (StringHelper.isEmptyString((Object)primaryKey)) {
            throw new MappingException("DN to find entry is null");
        }
        this.checkEntryClass(entryClass, true);
        try {
            List<AttributeData> results = this.find(primaryKey, ldapReturnAttributes);
            return results != null && results.size() > 0;
        }
        catch (EntryPersistenceException ex) {
            return false;
        }
    }

    public <T> boolean contains(Class<T> entryClass, String primaryKey) {
        return this.contains(entryClass, primaryKey, null);
    }

    public <T> T find(Class<T> entryClass, Object primaryKey) {
        return this.find(entryClass, primaryKey, null);
    }

    public <T> T find(Class<T> entryClass, Object primaryKey, String[] ldapReturnAttributes) {
        if (StringHelper.isEmptyString((Object)primaryKey)) {
            throw new MappingException("DN to find entry is null");
        }
        this.checkEntryClass(entryClass, true);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        return this.find(entryClass, primaryKey, ldapReturnAttributes, propertiesAnnotations);
    }

    protected <T> String[] getLdapAttributes(T entry, List<PropertyAnnotation> propertiesAnnotations, boolean isIgnoreLdapAttributesList) {
        List<String> attributes = this.getLdapAttributesList(entry, propertiesAnnotations, isIgnoreLdapAttributesList);
        if (attributes == null) {
            return null;
        }
        return attributes.toArray(new String[0]);
    }

    private <T> List<String> getLdapAttributesList(T entry, List<PropertyAnnotation> propertiesAnnotations, boolean isIgnoreLdapAttributesList) {
        ArrayList<String> attributes = new ArrayList<String>();
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            Annotation ldapAttribute;
            String propertyName = propertiesAnnotation.getPropertyName();
            if (!isIgnoreLdapAttributesList && (ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LdapAttributesList.class)) != null) {
                if (entry == null) {
                    return null;
                }
                List<AttributeData> ldapAttributesList = this.getAttributesFromLdapAttributesList(entry, ldapAttribute, propertyName);
                for (AttributeData attributeData : ldapAttributesList) {
                    String ldapAttributeName = attributeData.getName();
                    attributes.add(ldapAttributeName);
                }
            }
            if ((ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LdapAttribute.class)) == null) continue;
            String ldapAttributeName = ((LdapAttribute)ldapAttribute).name();
            if (StringHelper.isEmpty((String)ldapAttributeName)) {
                ldapAttributeName = propertyName;
            }
            attributes.add(ldapAttributeName);
        }
        if (attributes.size() == 0) {
            return null;
        }
        return attributes;
    }

    private <T> T find(Class<T> entryClass, Object primaryKey, String[] ldapReturnAttributes, List<PropertyAnnotation> propertiesAnnotations) {
        HashMap<String, List<AttributeData>> entriesAttributes = new HashMap<String, List<AttributeData>>();
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getLdapAttributes(null, propertiesAnnotations, false);
        }
        List<AttributeData> ldapAttributes = this.find(primaryKey.toString(), (String[])currentLdapReturnAttributes);
        entriesAttributes.put(primaryKey.toString(), ldapAttributes);
        List<T> results = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
        return results.get(0);
    }

    protected abstract List<AttributeData> find(String var1, String ... var2);

    protected boolean checkEntryClass(Class<?> entryClass, boolean isAllowSchemaEntry) {
        if (entryClass == null) {
            throw new MappingException("Entry class is null");
        }
        List<Annotation> entryAnnotations = ReflectHelper.getClassAnnotations(entryClass, LDAP_ENTRY_TYPE_ANNOTATIONS);
        Annotation ldapSchemaEntry = ReflectHelper.getAnnotationByType(entryAnnotations, LdapSchemaEntry.class);
        Annotation ldapEntry = ReflectHelper.getAnnotationByType(entryAnnotations, LdapEntry.class);
        if (isAllowSchemaEntry) {
            if (ldapSchemaEntry == null && ldapEntry == null) {
                throw new MappingException("Entry should has LdapEntry or LdapSchemaEntry annotation");
            }
        } else if (ldapEntry == null) {
            throw new MappingException("Entry should has LdapEntry annotation");
        }
        return true;
    }

    protected boolean isLdapSchemaEntry(Class<?> entryClass) {
        if (entryClass == null) {
            throw new MappingException("Entry class is null");
        }
        List<Annotation> entryAnnotations = ReflectHelper.getClassAnnotations(entryClass, LDAP_ENTRY_TYPE_ANNOTATIONS);
        return ReflectHelper.getAnnotationByType(entryAnnotations, LdapSchemaEntry.class) != null;
    }

    protected String[] getEntrySortBy(Class<?> entryClass) {
        if (entryClass == null) {
            throw new MappingException("Entry class is null");
        }
        List<Annotation> entryAnnotations = ReflectHelper.getClassAnnotations(entryClass, LDAP_ENTRY_TYPE_ANNOTATIONS);
        Annotation annotation = ReflectHelper.getAnnotationByType(entryAnnotations, LdapEntry.class);
        if (annotation == null) {
            return null;
        }
        return ((LdapEntry)annotation).sortBy();
    }

    public String[] getObjectClasses(Object entry, Class<?> entryClass) {
        Object[] typeObjectClasses = this.getTypeObjectClasses(entryClass);
        String[] customObjectClasses = this.getCustomObjectClasses(entry, entryClass);
        if (ArrayHelper.isEmpty((Object[])typeObjectClasses)) {
            return customObjectClasses;
        }
        String[] mergedArray = (String[])ArrayHelper.arrayMerge((Object[][])new String[][]{typeObjectClasses, customObjectClasses});
        HashSet<String> objecClassSet = new HashSet<String>();
        objecClassSet.addAll(Arrays.asList(mergedArray));
        return objecClassSet.toArray(new String[0]);
    }

    protected String[] getTypeObjectClasses(Class<?> entryClass) {
        List<Annotation> entryAnnotations = ReflectHelper.getClassAnnotations(entryClass, LDAP_ENTRY_TYPE_ANNOTATIONS);
        Annotation ldapObjectClass = ReflectHelper.getAnnotationByType(entryAnnotations, LdapObjectClass.class);
        if (ldapObjectClass == null) {
            return EMPTY_STRING_ARRAY;
        }
        return ((LdapObjectClass)ldapObjectClass).values();
    }

    protected String[] getCustomObjectClasses(Object entry, Class<?> entryClass) {
        ArrayList<String> result = new ArrayList<String>();
        List<PropertyAnnotation> customObjectAnnotations = this.getEntryCustomObjectClassAnnotations(entryClass);
        Iterator<PropertyAnnotation> i$ = customObjectAnnotations.iterator();
        if (i$.hasNext()) {
            PropertyAnnotation propertiesAnnotation = i$.next();
            String propertyName = propertiesAnnotation.getPropertyName();
            Getter getter = this.getGetter(entryClass, propertyName);
            if (getter == null) {
                throw new MappingException("Entry should has getter for property " + propertyName);
            }
            AttributeData attribute = this.getAttribute(propertyName, propertyName, getter, entry, false);
            if (attribute != null) {
                for (String objectClass : attribute.getValues()) {
                    if (objectClass == null) continue;
                    result.add(objectClass);
                }
            }
        }
        return result.toArray(new String[0]);
    }

    protected void setCustomObjectClasses(Object entry, Class<?> entryClass, String[] objectClasses) {
        block1: {
            List<PropertyAnnotation> customObjectAnnotations = this.getEntryCustomObjectClassAnnotations(entryClass);
            Iterator<PropertyAnnotation> i$ = customObjectAnnotations.iterator();
            if (!i$.hasNext()) break block1;
            PropertyAnnotation propertiesAnnotation = i$.next();
            String propertyName = propertiesAnnotation.getPropertyName();
            Setter setter = this.getSetter(entryClass, propertyName);
            if (setter == null) {
                throw new MappingException("Entry should has setter for property " + propertyName);
            }
            AttributeData attribute = new AttributeData(propertyName, objectClasses);
            this.setPropertyValue(propertyName, setter, entry, attribute, false);
        }
    }

    protected String getDNPropertyName(Class<?> entryClass) {
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryDnAnnotations(entryClass);
        if (propertiesAnnotations.size() == 0) {
            throw new MappingException("Entry should has property with annotation LdapDN");
        }
        if (propertiesAnnotations.size() > 1) {
            throw new MappingException("Entry should has only one property with annotation LdapDN");
        }
        return propertiesAnnotations.get(0).getPropertyName();
    }

    protected <T> List<T> createEntities(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, Map<String, List<AttributeData>> entriesAttributes) {
        return this.createEntities(entryClass, propertiesAnnotations, entriesAttributes, true);
    }

    protected <T> List<T> createEntities(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, Map<String, List<AttributeData>> entriesAttributes, boolean doSort) {
        String dnProperty = this.getDNPropertyName(entryClass);
        Setter dnSetter = this.getSetter(entryClass, dnProperty);
        if (dnSetter == null) {
            throw new MappingException("Entry should has getter for property " + dnProperty);
        }
        Object[] typeObjectClasses = this.getTypeObjectClasses(entryClass);
        Arrays.sort(typeObjectClasses);
        ArrayList<T> results = new ArrayList<T>(entriesAttributes.size());
        for (Map.Entry<String, List<AttributeData>> entryAttributes : entriesAttributes.entrySet()) {
            Annotation ldapAttribute;
            String propertyName;
            T entry;
            String dn = entryAttributes.getKey();
            List<AttributeData> attributes = entryAttributes.getValue();
            Map<String, AttributeData> attributesMap = this.getAttributesMap(attributes);
            ArrayList<Object> customObjectClasses = null;
            try {
                entry = ReflectHelper.createObjectByDefaultConstructor(entryClass);
            }
            catch (Exception ex) {
                throw new MappingException(String.format("Entry %s should has default constructor", entryClass));
            }
            results.add(entry);
            dnSetter.set(entry, dn);
            for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
                propertyName = propertiesAnnotation.getPropertyName();
                ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LdapAttribute.class);
                if (ldapAttribute == null) continue;
                String ldapAttributeName = ((LdapAttribute)ldapAttribute).name();
                if (StringHelper.isEmpty((String)ldapAttributeName)) {
                    ldapAttributeName = propertyName;
                }
                ldapAttributeName = ldapAttributeName.toLowerCase();
                AttributeData attributeData = attributesMap.get(ldapAttributeName);
                attributesMap.remove(ldapAttributeName);
                if (((LdapAttribute)ldapAttribute).ignoreDuringRead()) continue;
                Setter setter = this.getSetter(entryClass, propertyName);
                if (setter == null) {
                    throw new MappingException("Entry should has setter for property " + propertyName);
                }
                Annotation ldapJsonObject = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LdapJsonObject.class);
                boolean jsonObject = ldapJsonObject != null;
                this.setPropertyValue(propertyName, setter, entry, attributeData, jsonObject);
            }
            for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
                propertyName = propertiesAnnotation.getPropertyName();
                ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LdapAttributesList.class);
                if (ldapAttribute == null) continue;
                HashMap<String, LdapAttribute> ldapAttributesConfiguration = new HashMap<String, LdapAttribute>();
                for (LdapAttribute ldapAttributeConfiguration : ((LdapAttributesList)ldapAttribute).attributesConfiguration()) {
                    ldapAttributesConfiguration.put(ldapAttributeConfiguration.name(), ldapAttributeConfiguration);
                }
                Setter setter = this.getSetter(entryClass, propertyName);
                if (setter == null) {
                    throw new MappingException("Entry should has setter for property " + propertyName);
                }
                ArrayList<Object> propertyValue = new ArrayList<Object>();
                setter.set(entry, propertyValue);
                Class<?> entryItemType = ReflectHelper.getListType(setter);
                if (entryItemType == null) {
                    throw new MappingException("Entry property " + propertyName + " should has setter with specified element type");
                }
                String entryPropertyName = ((LdapAttributesList)ldapAttribute).name();
                Setter entryPropertyNameSetter = this.getSetter(entryItemType, entryPropertyName);
                if (entryPropertyNameSetter == null) {
                    throw new MappingException("Entry should has setter for property " + propertyName + "." + entryPropertyName);
                }
                String entryPropertyValue = ((LdapAttributesList)ldapAttribute).value();
                Setter entryPropertyValueSetter = this.getSetter(entryItemType, entryPropertyValue);
                if (entryPropertyValueSetter == null) {
                    throw new MappingException("Entry should has getter for property " + propertyName + "." + entryPropertyValue);
                }
                for (AttributeData entryAttribute : attributesMap.values()) {
                    Object listItem;
                    if (OBJECT_CLASS.equalsIgnoreCase(entryAttribute.getName())) {
                        Object[] objectClasses = entryAttribute.getValues();
                        if (ArrayHelper.isEmpty((Object[])objectClasses)) continue;
                        if (customObjectClasses == null) {
                            customObjectClasses = new ArrayList<Object>();
                        }
                        for (Object objectClass : objectClasses) {
                            int idx = Arrays.binarySearch(typeObjectClasses, objectClass, new Comparator<String>(){

                                @Override
                                public int compare(String o1, String o2) {
                                    return o1.toLowerCase().compareTo(o2.toLowerCase());
                                }
                            });
                            if (idx >= 0) continue;
                            customObjectClasses.add(objectClass);
                        }
                        continue;
                    }
                    LdapAttribute ldapAttributeConfiguration = (LdapAttribute)ldapAttributesConfiguration.get(entryAttribute.getName());
                    if (ldapAttributeConfiguration != null && ldapAttributeConfiguration.ignoreDuringRead() || (listItem = this.getListItem(propertyName, entryPropertyNameSetter, entryPropertyValueSetter, entryItemType, entryAttribute)) == null) continue;
                    propertyValue.add(listItem);
                }
                if (!doSort) continue;
                this.sortLdapAttributesListIfNeeded((LdapAttributesList)ldapAttribute, entryItemType, propertyValue);
            }
            if (customObjectClasses == null || customObjectClasses.size() <= 0) continue;
            this.setCustomObjectClasses(entry, entryClass, customObjectClasses.toArray(new String[0]));
        }
        return results;
    }

    public <T> List<T> createEntities(Class<T> entryClass, Map<String, List<AttributeData>> entriesAttributes) {
        this.checkEntryClass(entryClass, true);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        return this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
    }

    private <T> void sortLdapAttributesListIfNeeded(LdapAttributesList ldapAttribute, Class<T> entryItemType, List<?> list) {
        if (!ldapAttribute.sortByName()) {
            return;
        }
        this.sortListByProperties(entryItemType, list, ldapAttribute.name());
    }

    protected <T> void sortEntriesIfNeeded(Class<T> entryClass, List<T> entries) {
        Object[] sortByProperties = this.getEntrySortBy(entryClass);
        if (ArrayHelper.isEmpty((Object[])sortByProperties)) {
            return;
        }
        this.sortListByProperties(entryClass, entries, (String[])sortByProperties);
    }

    protected abstract <T> void sortListByProperties(Class<T> var1, List<T> var2, String ... var3);

    private Map<String, AttributeData> getAttributesMap(List<AttributeData> attributes) {
        HashMap<String, AttributeData> attributesMap = new HashMap<String, AttributeData>(attributes.size());
        for (AttributeData attribute : attributes) {
            attributesMap.put(attribute.getName().toLowerCase(), attribute);
        }
        return attributesMap;
    }

    private AttributeData getAttribute(String propertyName, String ldapAttributeName, Getter propertyValueGetter, Object entry, boolean jsonObject) {
        Object propertyValue = propertyValueGetter.get(entry);
        if (propertyValue == null) {
            return null;
        }
        Object[] attributeValues = new String[1];
        if (propertyValue instanceof String) {
            attributeValues[0] = StringHelper.toString((Object)propertyValue);
        } else if (propertyValue instanceof Boolean) {
            attributeValues[0] = propertyValue.toString();
        } else if (propertyValue instanceof Integer) {
            attributeValues[0] = propertyValue.toString();
        } else if (propertyValue instanceof Long) {
            attributeValues[0] = propertyValue.toString();
        } else if (propertyValue instanceof Date) {
            attributeValues[0] = this.encodeGeneralizedTime((Date)propertyValue);
        } else if (propertyValue instanceof String[]) {
            attributeValues = (String[])propertyValue;
        } else if (propertyValue instanceof List) {
            attributeValues = new String[((List)propertyValue).size()];
            int index = 0;
            for (Object tmpPropertyValue : (List)propertyValue) {
                if (jsonObject) {
                    attributeValues[index++] = this.convertJsonToString(tmpPropertyValue);
                    continue;
                }
                attributeValues[index++] = StringHelper.toString(tmpPropertyValue);
            }
        } else if (propertyValue instanceof LdapEnum) {
            attributeValues[0] = ((LdapEnum)propertyValue).getValue();
        } else if (propertyValue instanceof LdapEnum[]) {
            LdapEnum[] propertyValues = (LdapEnum[])propertyValue;
            attributeValues = new String[propertyValues.length];
            for (int i = 0; i < propertyValues.length; ++i) {
                attributeValues[i] = propertyValues[i] == null ? null : propertyValues[i].getValue();
            }
        } else if (jsonObject) {
            attributeValues[0] = this.convertJsonToString(propertyValue);
        } else {
            throw new MappingException("Entry property '" + propertyName + "' should has getter with String, String[], Boolean, Integer, Long, Date, List, LdapEnum or LdapEnum[] return type or has annotation LdapJsonObject");
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Property: %s, LdapProperty: %s, PropertyValue: %s", propertyName, ldapAttributeName, Arrays.toString(attributeValues)));
        }
        if (attributeValues.length == 0) {
            attributeValues = new String[]{};
        } else if (attributeValues.length == 1 && StringHelper.isEmpty((String)attributeValues[0])) {
            return null;
        }
        return new AttributeData(ldapAttributeName, (String[])attributeValues);
    }

    private String convertJsonToString(Object propertyValue) {
        try {
            String value = jsonObjectMapper.writeValueAsString(propertyValue);
            return value;
        }
        catch (Exception ex) {
            log.error("Failed to convert '{}' to json value:", propertyValue, (Object)ex);
            throw new MappingException(String.format("Failed to convert '%s' to json value", propertyValue));
        }
    }

    protected List<AttributeData> getAttributesListForPersist(Object entry, List<PropertyAnnotation> propertiesAnnotations) {
        ArrayList<AttributeData> attributes = new ArrayList<AttributeData>();
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            List<AttributeData> listAttributes;
            String propertyName = propertiesAnnotation.getPropertyName();
            Annotation ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LdapAttribute.class);
            if (ldapAttribute != null) {
                AttributeData attribute = this.getAttributeFromLdapAttribute(entry, ldapAttribute, propertiesAnnotation, propertyName);
                if (attribute == null) continue;
                attributes.add(attribute);
                continue;
            }
            ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LdapAttributesList.class);
            if (ldapAttribute == null || (listAttributes = this.getAttributesFromLdapAttributesList(entry, ldapAttribute, propertyName)) == null) continue;
            attributes.addAll(listAttributes);
        }
        return attributes;
    }

    private AttributeData getAttributeFromLdapAttribute(Object entry, Annotation ldapAttribute, PropertyAnnotation propertiesAnnotation, String propertyName) {
        Getter getter;
        Class<?> entryClass = entry.getClass();
        String ldapAttributeName = ((LdapAttribute)ldapAttribute).name();
        if (StringHelper.isEmpty((String)ldapAttributeName)) {
            ldapAttributeName = propertyName;
        }
        if ((getter = this.getGetter(entryClass, propertyName)) == null) {
            throw new MappingException("Entry should has getter for property " + propertyName);
        }
        Annotation ldapJsonObject = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LdapJsonObject.class);
        boolean jsonObject = ldapJsonObject != null;
        AttributeData attribute = this.getAttribute(propertyName, ldapAttributeName, getter, entry, jsonObject);
        return attribute;
    }

    private List<AttributeData> getAttributesFromLdapAttributesList(Object entry, Annotation ldapAttribute, String propertyName) {
        String entryPropertyName;
        Class<?> entryClass = entry.getClass();
        ArrayList<AttributeData> listAttributes = new ArrayList<AttributeData>();
        Getter getter = this.getGetter(entryClass, propertyName);
        if (getter == null) {
            throw new MappingException("Entry should has getter for property " + propertyName);
        }
        Object propertyValue = getter.get(entry);
        if (propertyValue == null) {
            return null;
        }
        if (!(propertyValue instanceof List)) {
            throw new MappingException("Entry property should has List base type");
        }
        Class<?> elementType = ReflectHelper.getListType(getter);
        Getter entryPropertyNameGetter = this.getGetter(elementType, entryPropertyName = ((LdapAttributesList)ldapAttribute).name());
        if (entryPropertyNameGetter == null) {
            throw new MappingException("Entry should has getter for property " + propertyName + "." + entryPropertyName);
        }
        String entryPropertyValue = ((LdapAttributesList)ldapAttribute).value();
        Getter entryPropertyValueGetter = this.getGetter(elementType, entryPropertyValue);
        if (entryPropertyValueGetter == null) {
            throw new MappingException("Entry should has getter for property " + propertyName + "." + entryPropertyValue);
        }
        for (Object entryAttribute : (List)propertyValue) {
            AttributeData attribute = this.getAttribute(propertyName, entryPropertyNameGetter, entryPropertyValueGetter, entryAttribute, false);
            if (attribute == null) continue;
            listAttributes.add(attribute);
        }
        return listAttributes;
    }

    protected <T> List<PropertyAnnotation> getEntryPropertyAnnotations(Class<T> entryClass) {
        return this.getEntryClassAnnotations(entryClass, "property_", LDAP_ENTRY_PROPERTY_ANNOTATIONS);
    }

    protected <T> List<PropertyAnnotation> getEntryDnAnnotations(Class<T> entryClass) {
        return this.getEntryClassAnnotations(entryClass, "dn_", LDAP_DN_PROPERTY_ANNOTATION);
    }

    protected <T> List<PropertyAnnotation> getEntryCustomObjectClassAnnotations(Class<T> entryClass) {
        return this.getEntryClassAnnotations(entryClass, "custom_", LDAP_CUSTOM_OBJECT_CLASS_PROPERTY_ANNOTATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<PropertyAnnotation> getEntryClassAnnotations(Class<T> entryClass, String keyCategory, Class<?>[] annotationTypes) {
        String key = keyCategory + entryClass.getName();
        List<PropertyAnnotation> annotations = this.classAnnotations.get(key);
        if (annotations == null) {
            Object object = classAnnotationsLock;
            synchronized (object) {
                annotations = this.classAnnotations.get(key);
                if (annotations == null) {
                    Map<String, List<Annotation>> annotationsMap = ReflectHelper.getPropertiesAnnotations(entryClass, annotationTypes);
                    annotations = this.convertToPropertyAnnotationList(annotationsMap);
                    this.classAnnotations.put(key, annotations);
                }
            }
        }
        return annotations;
    }

    private List<PropertyAnnotation> convertToPropertyAnnotationList(Map<String, List<Annotation>> annotations) {
        ArrayList<PropertyAnnotation> result = new ArrayList<PropertyAnnotation>(annotations.size());
        for (Map.Entry<String, List<Annotation>> entry : annotations.entrySet()) {
            result.add(new PropertyAnnotation(entry.getKey(), entry.getValue()));
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Getter getGetter(Class<T> entryClass, String propertyName) {
        String key = entryClass.getName() + "." + propertyName;
        Getter getter = this.classGetters.get(key);
        if (getter == null) {
            Object object = classGettersLock;
            synchronized (object) {
                getter = this.classGetters.get(key);
                if (getter == null) {
                    getter = ReflectHelper.getGetter(entryClass, propertyName);
                    this.classGetters.put(key, getter);
                }
            }
        }
        return getter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Setter getSetter(Class<T> entryClass, String propertyName) {
        String key = entryClass.getName() + "." + propertyName;
        Setter setter = this.classSetters.get(key);
        if (setter == null) {
            Object object = classSettersLock;
            synchronized (object) {
                setter = this.classSetters.get(key);
                if (setter == null) {
                    setter = ReflectHelper.getSetter(entryClass, propertyName);
                    this.classSetters.put(key, setter);
                }
            }
        }
        return setter;
    }

    private AttributeData getAttribute(String propertyName, Getter propertyNameGetter, Getter propertyValueGetter, Object entry, boolean jsonObject) {
        Object ldapAttributeName = propertyNameGetter.get(entry);
        if (ldapAttributeName == null) {
            return null;
        }
        return this.getAttribute(propertyName, ldapAttributeName.toString(), propertyValueGetter, entry, jsonObject);
    }

    private void setPropertyValue(String propertyName, Setter propertyValueSetter, Object entry, AttributeData attribute, boolean jsonObject) {
        if (attribute == null) {
            return;
        }
        log.debug(String.format("LdapProperty: %s, AttributeName: %s, AttributeValue: %s", propertyName, attribute.getName(), Arrays.toString(attribute.getValues())));
        Class<?> parameterType = ReflectHelper.getSetterType(propertyValueSetter);
        if (parameterType.equals(String.class)) {
            propertyValueSetter.set(entry, attribute.getValue());
        } else if (parameterType.equals(Boolean.class) || parameterType.equals(Boolean.TYPE)) {
            propertyValueSetter.set(entry, attribute.getValue() == null ? null : Boolean.valueOf(attribute.getValue()));
        } else if (parameterType.equals(Integer.class) || parameterType.equals(Integer.TYPE)) {
            propertyValueSetter.set(entry, attribute.getValue() == null ? null : Integer.valueOf(attribute.getValue()));
        } else if (parameterType.equals(Long.class) || parameterType.equals(Long.TYPE)) {
            propertyValueSetter.set(entry, attribute.getValue() == null ? null : Long.valueOf(attribute.getValue()));
        } else if (parameterType.equals(Date.class)) {
            propertyValueSetter.set(entry, this.decodeGeneralizedTime(attribute.getValue()));
        } else if (parameterType.equals(String[].class)) {
            propertyValueSetter.set(entry, attribute.getValues());
        } else if (ReflectHelper.assignableFrom(parameterType, List.class)) {
            if (jsonObject) {
                String[] stringValues = attribute.getValues();
                ArrayList<Object> jsonValues = new ArrayList<Object>(stringValues.length);
                for (String stringValue : stringValues) {
                    Object jsonValue = this.convertStringToJson(entry, ReflectHelper.getListType(propertyValueSetter), stringValue);
                    jsonValues.add(jsonValue);
                }
                propertyValueSetter.set(entry, jsonValues);
            } else {
                propertyValueSetter.set(entry, Arrays.asList(attribute.getValues()));
            }
        } else {
            if (ReflectHelper.assignableFrom(parameterType, LdapEnum.class)) {
                try {
                    propertyValueSetter.set(entry, parameterType.getMethod("resolveByValue", String.class).invoke(parameterType.getEnumConstants()[0], attribute.getValue()));
                }
                catch (Exception ex) {
                    throw new MappingException("Failed to resolve Enum by value " + attribute.getValue(), ex);
                }
            }
            if (ReflectHelper.assignableFrom(parameterType, LdapEnum[].class)) {
                Method enumResolveByValue;
                Class<?> itemType = parameterType.getComponentType();
                try {
                    enumResolveByValue = itemType.getMethod("resolveByValue", String.class);
                }
                catch (Exception ex) {
                    throw new MappingException("Failed to resolve Enum by value " + Arrays.toString(attribute.getValues()), ex);
                }
                String[] attributeValues = attribute.getValues();
                LdapEnum[] ldapEnums = (LdapEnum[])ReflectHelper.createArray(itemType, attributeValues.length);
                for (int i = 0; i < attributeValues.length; ++i) {
                    try {
                        ldapEnums[i] = (LdapEnum)enumResolveByValue.invoke(itemType.getEnumConstants()[0], attributeValues[i]);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new MappingException("Failed to resolve Enum by value " + Arrays.toString(attribute.getValues()), ex);
                    }
                }
                propertyValueSetter.set(entry, ldapEnums);
            } else if (jsonObject) {
                String stringValue = attribute.getValue();
                Object jsonValue = this.convertStringToJson(entry, parameterType, stringValue);
                propertyValueSetter.set(entry, jsonValue);
            } else {
                throw new MappingException("Entry property '" + propertyName + "' should has setter with String, Boolean, Integer, Long, Date, String[], List, LdapEnum or LdapEnum[] parameter type or has annotation LdapJsonObject");
            }
        }
    }

    private Object convertStringToJson(Object entry, Class<?> parameterType, String stringValue) {
        try {
            Object jsonValue = jsonObjectMapper.readValue(stringValue, parameterType);
            return jsonValue;
        }
        catch (Exception ex) {
            log.error("Failed to convert json value '{}' to object: ", (Object)stringValue, (Object)ex);
            throw new MappingException(String.format("Failed to convert json value '%s' to object", stringValue));
        }
    }

    private Object getListItem(String propertyName, Setter propertyNameSetter, Setter propertyValueSetter, Class<?> classType, AttributeData attribute) {
        Object result;
        if (attribute == null) {
            return null;
        }
        try {
            result = ReflectHelper.createObjectByDefaultConstructor(classType);
        }
        catch (Exception ex) {
            throw new MappingException(String.format("Entry %s should has default constructor", classType));
        }
        propertyNameSetter.set(result, attribute.getName());
        this.setPropertyValue(propertyName, propertyValueSetter, result, attribute, false);
        return result;
    }

    protected abstract String encodeGeneralizedTime(Date var1);

    protected abstract Date decodeGeneralizedTime(String var1);

    protected <T> Object getDNValue(Object entry, Class<T> entryClass) {
        String dnProperty = this.getDNPropertyName(entryClass);
        Getter dnGetter = this.getGetter(entryClass, dnProperty);
        if (dnGetter == null) {
            throw new MappingException("Entry should has getter for property " + dnProperty);
        }
        Object dnValue = dnGetter.get(entry);
        if (StringHelper.isEmptyString((Object)dnValue)) {
            throw new MappingException("Entry should has not null base DN property value");
        }
        return dnValue;
    }

    protected <T> String getEntryKey(T entry, boolean caseSensetive, Getter[] propertyGetters) {
        StringBuilder sb = new StringBuilder("key");
        for (Getter getter : propertyGetters) {
            sb.append("__").append(getter.get(entry));
        }
        if (caseSensetive) {
            return sb.toString();
        }
        return sb.toString().toLowerCase();
    }

    private Map<String, AttributeData> getAttributesDataMap(List<AttributeData> attributesData) {
        HashMap<String, AttributeData> result = new HashMap<String, AttributeData>();
        for (AttributeData attributeData : attributesData) {
            result.put(attributeData.getName(), attributeData);
        }
        return result;
    }

    protected String getEntryKey(Object dnValue, boolean caseSensetive, List<PropertyAnnotation> propertiesAnnotations, List<AttributeData> attributesData) {
        StringBuilder sb = new StringBuilder("_HASH__").append(((String)dnValue).toLowerCase()).append("__");
        ArrayList<String> processedProperties = new ArrayList<String>();
        Map<String, AttributeData> attributesDataMap = this.getAttributesDataMap(attributesData);
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            Annotation ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LdapAttribute.class);
            if (ldapAttribute == null) continue;
            String ldapAttributeName = ((LdapAttribute)ldapAttribute).name();
            if (StringHelper.isEmpty((String)ldapAttributeName)) {
                ldapAttributeName = propertiesAnnotation.getPropertyName();
            }
            processedProperties.add(ldapAttributeName);
            Object[] values = null;
            AttributeData attributeData = attributesDataMap.get(ldapAttributeName);
            if (attributeData != null && attributeData.getValues() != null) {
                values = (String[])attributeData.getValues().clone();
                Arrays.sort(values);
            }
            this.addPropertyWithValuesToKey(sb, ldapAttributeName, (String[])values);
        }
        for (AttributeData attributeData : attributesData) {
            if (processedProperties.contains(attributeData.getName())) continue;
            this.addPropertyWithValuesToKey(sb, attributeData.getName(), attributeData.getValues());
        }
        if (caseSensetive) {
            return sb.toString();
        }
        return sb.toString().toLowerCase();
    }

    private void addPropertyWithValuesToKey(StringBuilder sb, String propertyName, String[] values) {
        sb.append(':').append(propertyName).append('=');
        if (values == null) {
            sb.append("null");
        } else if (values.length == 1) {
            sb.append(values[0]);
        } else {
            Object[] tmpValues = (String[])values.clone();
            Arrays.sort(tmpValues);
            for (int i = 0; i < tmpValues.length; ++i) {
                sb.append((String)tmpValues[i]);
                if (i >= tmpValues.length - 1) continue;
                sb.append(';');
            }
        }
    }

    public int getHashCode(Object entry) {
        if (entry == null) {
            throw new MappingException("Entry to persist is null");
        }
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, false);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object dnValue = this.getDNValue(entry, entryClass);
        List<AttributeData> attributes = this.getAttributesListForPersist(entry, propertiesAnnotations);
        String key = this.getEntryKey(dnValue, false, propertiesAnnotations, attributes);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Entry key HashCode is: %s", key.hashCode()));
        }
        return key.hashCode();
    }

    public abstract int getSupportedLDAPVersion();

    public boolean isOpen() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public void refresh(Object entry) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public void clear() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public void close() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public Query createNamedQuery(String name) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public Query createNativeQuery(String sqlString) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public Query createQuery(String qlString) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public void flush() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public Object getDelegate() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public FlushModeType getFlushMode() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public <T> T getReference(Class<T> entryClass, Object primaryKey) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public EntityTransaction getTransaction() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public void joinTransaction() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public void lock(Object entry, LockModeType lockMode) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public void setFlushMode(FlushModeType flushMode) {
        throw new UnsupportedOperationException("Method not implemented.");
    }
}

