/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap.persistence;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.gluu.site.ldap.OperationsFacade;
import org.gluu.site.ldap.exception.ConnectionException;
import org.gluu.site.ldap.persistence.AbstractEntryManager;
import org.gluu.site.ldap.persistence.AttributeData;
import org.gluu.site.ldap.persistence.AttributeDataModification;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.DeleteNotifier;
import org.gluu.site.ldap.persistence.LdifDataUtility;
import org.gluu.site.ldap.persistence.PropertyAnnotation;
import org.gluu.site.ldap.persistence.annotation.LdapEnum;
import org.gluu.site.ldap.persistence.exception.AuthenticationException;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.gluu.site.ldap.persistence.exception.InvalidArgumentException;
import org.gluu.site.ldap.persistence.exception.MappingException;
import org.gluu.site.ldap.persistence.property.Getter;
import org.gluu.site.ldap.persistence.property.Setter;
import org.gluu.site.ldap.persistence.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.ldap.model.SearchScope;
import org.xdi.ldap.model.SortOrder;
import org.xdi.ldap.model.VirtualListViewResponse;
import org.xdi.util.ArrayHelper;
import org.xdi.util.StringHelper;

public class LdapEntryManager
extends AbstractEntryManager
implements Serializable {
    private static final long serialVersionUID = -2544614410981223105L;
    private static final Logger log = LoggerFactory.getLogger(LdapEntryManager.class);
    private static final Class<?>[] GROUP_BY_ALLOWED_DATA_TYPES = new Class[]{String.class, Date.class, Integer.class, LdapEnum.class};
    private static final Class<?>[] SUM_BY_ALLOWED_DATA_TYPES = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Float.class, Double.TYPE, Double.class};
    private static final String[] NO_STRINGS = new String[0];
    private static final Comparator<String> LINE_LENGHT_COMPARATOR = new LineLenghtComparator<String>(false);
    private transient OperationsFacade ldapOperationService;
    private transient List<DeleteNotifier> subscribers;

    public LdapEntryManager(OperationsFacade ldapOperationService) {
        this.ldapOperationService = ldapOperationService;
        this.subscribers = new LinkedList<DeleteNotifier>();
    }

    public boolean destroy() {
        boolean destroyResult = this.ldapOperationService.destroy();
        return destroyResult;
    }

    public OperationsFacade getLdapOperationService() {
        return this.ldapOperationService;
    }

    public void addDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.add(subscriber);
    }

    public void removerDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.remove(subscriber);
    }

    @Override
    protected void persist(String dn, List<AttributeData> attributes) {
        ArrayList<Attribute> ldapAttributes = new ArrayList<Attribute>(attributes.size());
        for (AttributeData attribute : attributes) {
            if (!ArrayHelper.isNotEmpty((Object[])attribute.getValues()) || !StringHelper.isNotEmpty((String)attribute.getValues()[0])) continue;
            ldapAttributes.add(new Attribute(attribute.getName(), attribute.getValues()));
        }
        try {
            boolean result = this.ldapOperationService.addEntry(dn, ldapAttributes);
            if (!result) {
                throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn));
            }
        }
        catch (ConnectionException ex) {
            throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn), ex.getCause());
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn), ex);
        }
    }

    @Override
    public void merge(String dn, List<AttributeDataModification> attributeDataModifications) {
        try {
            boolean result;
            ArrayList<Modification> modifications = new ArrayList<Modification>(attributeDataModifications.size());
            for (AttributeDataModification attributeDataModification : attributeDataModifications) {
                AttributeData attribute = attributeDataModification.getAttribute();
                AttributeData oldAttribute = attributeDataModification.getOldAttribute();
                Modification modification = null;
                if (AttributeDataModification.AttributeModificationType.ADD.equals((Object)attributeDataModification.getModificationType())) {
                    modification = new Modification(ModificationType.ADD, attribute.getName(), attribute.getValues());
                } else if (AttributeDataModification.AttributeModificationType.REMOVE.equals((Object)attributeDataModification.getModificationType())) {
                    modification = new Modification(ModificationType.DELETE, oldAttribute.getName(), oldAttribute.getValues());
                } else if (AttributeDataModification.AttributeModificationType.REPLACE.equals((Object)attributeDataModification.getModificationType())) {
                    if (attribute.getValues().length == 1) {
                        modification = new Modification(ModificationType.REPLACE, attribute.getName(), attribute.getValues());
                    } else {
                        Object[] oldValues = (String[])ArrayHelper.arrayClone((Object[])oldAttribute.getValues());
                        Object[] newValues = (String[])ArrayHelper.arrayClone((Object[])attribute.getValues());
                        Arrays.sort(oldValues);
                        Arrays.sort(newValues);
                        boolean[] retainOldValues = new boolean[oldValues.length];
                        Arrays.fill(retainOldValues, false);
                        ArrayList<Object> addValues = new ArrayList<Object>();
                        ArrayList<Object> removeValues = new ArrayList<Object>();
                        for (Object value : newValues) {
                            int idx = Arrays.binarySearch(oldValues, value, new Comparator<String>(){

                                @Override
                                public int compare(String o1, String o2) {
                                    return o1.toLowerCase().compareTo(o2.toLowerCase());
                                }
                            });
                            if (idx >= 0) {
                                retainOldValues[idx] = true;
                                continue;
                            }
                            addValues.add(value);
                        }
                        for (int i = 0; i < oldValues.length; ++i) {
                            if (retainOldValues[i]) continue;
                            removeValues.add(oldValues[i]);
                        }
                        if (removeValues.size() > 0) {
                            Modification removeModification = new Modification(ModificationType.DELETE, attribute.getName(), removeValues.toArray(new String[removeValues.size()]));
                            modifications.add(removeModification);
                        }
                        if (addValues.size() > 0) {
                            Modification addModification = new Modification(ModificationType.ADD, attribute.getName(), addValues.toArray(new String[addValues.size()]));
                            modifications.add(addModification);
                        }
                    }
                }
                if (modification == null) continue;
                modifications.add(modification);
            }
            if (modifications.size() > 0 && !(result = this.ldapOperationService.updateEntry(dn, (List<Modification>)modifications))) {
                throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn));
            }
        }
        catch (ConnectionException ex) {
            throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn), ex.getCause());
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn), ex);
        }
    }

    @Override
    protected void remove(String dn) {
        try {
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onBeforeRemove(dn);
            }
            this.ldapOperationService.delete(dn);
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onAfterRemove(dn);
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to remove entry: %s", dn), ex);
        }
    }

    @Override
    public void removeWithSubtree(String dn) {
        try {
            if (this.ldapOperationService.getConnectionProvider().isSupportsSubtreeDeleteRequestControl()) {
                for (DeleteNotifier subscriber : this.subscribers) {
                    subscriber.onBeforeRemove(dn);
                }
                this.ldapOperationService.deleteWithSubtree(dn);
                for (DeleteNotifier subscriber : this.subscribers) {
                    subscriber.onAfterRemove(dn);
                }
            } else {
                this.removeSubtreeThroughIteration(dn);
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to remove entry: %s", dn), ex);
        }
    }

    private void removeSubtreeThroughIteration(String dn) {
        SearchResult searchResult = null;
        try {
            searchResult = this.ldapOperationService.search(dn, Filter.createPresenceFilter((String)"objectClass"), 0, 0, null, "dn");
            if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                throw new EntryPersistenceException(String.format("Failed to find sub-entries of entry '%s' for removal", dn));
            }
        }
        catch (LDAPSearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to find sub-entries of entry '%s' for removal", dn), ex);
        }
        ArrayList<String> removeEntriesDn = new ArrayList<String>(searchResult.getEntryCount());
        for (SearchResultEntry searchResultEntry : searchResult.getSearchEntries()) {
            removeEntriesDn.add(searchResultEntry.getDN());
        }
        Collections.sort(removeEntriesDn, LINE_LENGHT_COMPARATOR);
        for (String removeEntryDn : removeEntriesDn) {
            this.remove(removeEntryDn);
        }
    }

    @Override
    protected List<AttributeData> find(String dn, String ... ldapReturnAttributes) {
        try {
            SearchResultEntry entry = this.ldapOperationService.lookup(dn, ldapReturnAttributes);
            List<AttributeData> result = this.getAttributeDataList(entry);
            if (result != null) {
                return result;
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn), ex);
        }
        throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn));
    }

    public <T> List<T> findEntries(Object entry) {
        return this.findEntries(entry, 0);
    }

    public <T> List<T> findEntries(Object entry, int searchLimit) {
        return this.findEntries(entry, searchLimit, 0);
    }

    public <T> List<T> findEntries(Object entry, int searchLimit, int sizeLimit) {
        if (entry == null) {
            throw new MappingException("Entry to find is null");
        }
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, false);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object dnValue = this.getDNValue(entry, entryClass);
        List<AttributeData> attributes = this.getAttributesListForPersist(entry, propertiesAnnotations);
        Filter searchFilter = this.createFilterByEntry(entry, entryClass, attributes);
        return this.findEntries(dnValue.toString(), entryClass, searchFilter, null, searchLimit);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter) {
        return this.findEntries(baseDN, entryClass, filter, SearchScope.SUB);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope) {
        return this.findEntries(baseDN, entryClass, filter, scope, null, 0);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, String[] ldapReturnAttributes, Filter filter) {
        return this.findEntries(baseDN, entryClass, ldapReturnAttributes, filter, SearchScope.SUB);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, String[] ldapReturnAttributes, Filter filter, SearchScope scope) {
        return this.findEntries(baseDN, entryClass, filter, scope, ldapReturnAttributes, 0);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, int searchLimit) {
        return this.findEntries(baseDN, entryClass, filter, null, searchLimit, 0);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, int searchLimit, int sizeLimit) {
        return this.findEntries(baseDN, entryClass, filter, null, searchLimit, sizeLimit);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes, int searchLimit) {
        return this.findEntries(baseDN, entryClass, filter, ldapReturnAttributes, searchLimit, 0);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, int searchLimit) {
        return this.findEntries(baseDN, entryClass, filter, scope, ldapReturnAttributes, searchLimit, 0);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes, int searchLimit, int sizeLimit) {
        return this.findEntries(baseDN, entryClass, filter, SearchScope.SUB, ldapReturnAttributes, searchLimit, sizeLimit);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, int searchLimit, int sizeLimit) {
        return this.findEntries(baseDN, entryClass, filter, SearchScope.SUB, ldapReturnAttributes, null, 0, searchLimit, sizeLimit);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, BatchOperation<T> batchOperation, int startIndex, int searchLimit, int sizeLimit) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getLdapAttributes(null, propertiesAnnotations, false);
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        SearchResult searchResult = null;
        try {
            searchResult = this.ldapOperationService.search(baseDN, searchFilter, scope, batchOperation, startIndex, searchLimit, sizeLimit, null, (String[])currentLdapReturnAttributes);
            if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter), ex);
        }
        if (searchResult.getEntryCount() == 0) {
            return new ArrayList(0);
        }
        List<T> entries = this.createEntities(entryClass, propertiesAnnotations, searchResult.getSearchEntries().toArray(new SearchResultEntry[searchResult.getSearchEntries().size()]));
        this.sortEntriesIfNeeded(entryClass, entries);
        return entries;
    }

    public <T> List<T> findEntriesSearchSearchResult(String baseDN, Class<T> entryClass, Filter filter, int startIndex, int count, int searchLimit, String sortBy, SortOrder sortOrder, VirtualListViewResponse vlvResponse, String[] ldapReturnAttributes) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getLdapAttributes(null, propertiesAnnotations, false);
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        SearchResult searchResult = null;
        try {
            searchResult = this.ldapOperationService.searchSearchResult(baseDN, searchFilter, SearchScope.SUB, startIndex, count, searchLimit, sortBy, sortOrder, vlvResponse, (String[])currentLdapReturnAttributes);
            if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter), ex);
        }
        if (searchResult.getEntryCount() == 0) {
            return new ArrayList(0);
        }
        List<T> entries = this.createEntitiesVirtualListView(entryClass, propertiesAnnotations, searchResult.getSearchEntries().toArray(new SearchResultEntry[searchResult.getSearchEntries().size()]));
        return entries;
    }

    public <T> List<T> findEntriesVirtualListView(String baseDN, Class<T> entryClass, Filter filter, int startIndex, int count, String sortBy, SortOrder sortOrder, VirtualListViewResponse vlvResponse, String[] ldapReturnAttributes) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getLdapAttributes(null, propertiesAnnotations, false);
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        SearchResult searchResult = null;
        try {
            searchResult = this.ldapOperationService.searchVirtualListView(baseDN, searchFilter, SearchScope.SUB, startIndex, count, sortBy, sortOrder, vlvResponse, (String[])currentLdapReturnAttributes);
            if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter), ex);
        }
        if (searchResult.getEntryCount() == 0) {
            return new ArrayList(0);
        }
        List<T> entries = this.createEntitiesVirtualListView(entryClass, propertiesAnnotations, searchResult.getSearchEntries().toArray(new SearchResultEntry[searchResult.getSearchEntries().size()]));
        return entries;
    }

    public <T> boolean contains(String baseDN, Class<T> entryClass, Filter filter) {
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        String[] ldapReturnAttributes = this.getLdapAttributes(null, propertiesAnnotations, false);
        return this.contains(baseDN, filter, objectClasses, ldapReturnAttributes);
    }

    @Override
    protected boolean contains(String baseDN, List<AttributeData> attributes, String[] objectClasses, String ... ldapReturnAttributes) {
        Filter[] attributesFilters = this.createAttributesFilter(attributes);
        Filter attributesFilter = null;
        if (attributesFilters != null) {
            attributesFilter = Filter.createANDFilter((Filter[])attributesFilters);
        }
        return this.contains(baseDN, attributesFilter, objectClasses, ldapReturnAttributes);
    }

    protected boolean contains(String baseDN, Filter filter, String[] objectClasses, String[] ldapReturnAttributes) {
        SearchResult searchResult;
        block4: {
            if (StringHelper.isEmptyString((Object)baseDN)) {
                throw new MappingException("Base DN to check contain entries is null");
            }
            Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
            searchResult = null;
            try {
                searchResult = this.ldapOperationService.search(baseDN, searchFilter, 1, 1, null, ldapReturnAttributes);
                if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                    throw new EntryPersistenceException(String.format("Failed to find entry with baseDN: %s, filter: %s", baseDN, searchFilter));
                }
            }
            catch (LDAPSearchException ex) {
                if (ResultCode.NO_SUCH_OBJECT.equals((Object)ex.getResultCode())) break block4;
                throw new EntryPersistenceException(String.format("Failed to find entry with baseDN: %s, filter: %s", baseDN, searchFilter), ex);
            }
        }
        return searchResult != null && searchResult.getEntryCount() > 0;
    }

    private Filter addObjectClassFilter(Filter filter, String[] objectClasses) {
        if (objectClasses.length == 0) {
            return filter;
        }
        Filter[] objectClassFilter = new Filter[objectClasses.length];
        for (int i = 0; i < objectClasses.length; ++i) {
            objectClassFilter[i] = Filter.createEqualityFilter((String)"objectClass", (String)objectClasses[i]);
        }
        Filter searchFilter = Filter.createANDFilter((Filter[])objectClassFilter);
        if (filter != null) {
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createANDFilter((Filter[])objectClassFilter), filter});
        }
        return searchFilter;
    }

    private <T> List<T> createEntities(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, SearchResultEntry ... searchResultEntries) {
        ArrayList<T> result = new ArrayList<T>(searchResultEntries.length);
        HashMap<String, List<AttributeData>> entriesAttributes = new HashMap<String, List<AttributeData>>(100);
        int count = 0;
        for (int i = 0; i < searchResultEntries.length; ++i) {
            SearchResultEntry entry = searchResultEntries[i];
            entriesAttributes.put(entry.getDN(), this.getAttributeDataList(entry));
            searchResultEntries[i] = null;
            if (++count < 100) continue;
            List<T> currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
            result.addAll(currentResult);
            entriesAttributes = new HashMap(100);
            count = 0;
        }
        List<T> currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
        result.addAll(currentResult);
        return result;
    }

    private <T> List<T> createEntitiesVirtualListView(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, SearchResultEntry ... searchResultEntries) {
        LinkedList<Object> result = new LinkedList<Object>();
        LinkedHashMap<String, List<AttributeData>> entriesAttributes = new LinkedHashMap<String, List<AttributeData>>(100);
        int count = 0;
        for (int i = 0; i < searchResultEntries.length; ++i) {
            ++count;
            SearchResultEntry entry = searchResultEntries[i];
            LinkedList<AttributeData> attributeDataLinkedList = new LinkedList<AttributeData>();
            attributeDataLinkedList.addAll(this.getAttributeDataList(entry));
            entriesAttributes.put(entry.getDN(), attributeDataLinkedList);
            searchResultEntries[i] = null;
            if (count < 100) continue;
            LinkedList<T> currentResult = new LinkedList<T>();
            currentResult.addAll(this.createEntities(entryClass, propertiesAnnotations, entriesAttributes, false));
            result.addAll(currentResult);
            entriesAttributes = new LinkedHashMap(100);
            count = 0;
        }
        List<T> currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes, false);
        result.addAll(currentResult);
        return result;
    }

    private Filter[] createAttributesFilter(List<AttributeData> attributes) {
        if (attributes == null || attributes.size() == 0) {
            return null;
        }
        ArrayList<Filter> results = new ArrayList<Filter>(attributes.size());
        for (AttributeData attribute : attributes) {
            String attributeName = attribute.getName();
            for (String value : attribute.getValues()) {
                Filter filter = Filter.createEqualityFilter((String)attributeName, (String)value);
                results.add(filter);
            }
        }
        return results.toArray(new Filter[results.size()]);
    }

    private List<AttributeData> getAttributeDataList(SearchResultEntry entry) {
        if (entry == null) {
            return null;
        }
        ArrayList<AttributeData> result = new ArrayList<AttributeData>();
        for (Attribute attribute : entry.getAttributes()) {
            String[] attributeValueStrings = NO_STRINGS;
            String attributeName = attribute.getName();
            if (log.isTraceEnabled() && attribute.needsBase64Encoding()) {
                log.trace("Found binary attribute: " + attributeName + ". Is defined in LDAP config: " + this.ldapOperationService.isBinaryAttribute(attributeName));
            }
            if (attribute.needsBase64Encoding() && this.ldapOperationService.isBinaryAttribute(attributeName)) {
                byte[][] attributeValues = attribute.getValueByteArrays();
                if (attributeValues != null) {
                    attributeValueStrings = new String[attributeValues.length];
                    for (int i = 0; i < attributeValues.length; ++i) {
                        attributeValueStrings[i] = Base64.encodeBase64String((byte[])attributeValues[i]);
                        if (!log.isTraceEnabled()) continue;
                        log.trace("Binary attribute: " + attribute.getName() + " value (hex): " + Hex.encodeHexString((byte[])attributeValues[i]) + " value (base64): " + attributeValueStrings[i]);
                    }
                }
            } else {
                attributeValueStrings = attribute.getValues();
            }
            AttributeData tmpAttribute = new AttributeData(attribute.getName(), attributeValueStrings);
            result.add(tmpAttribute);
        }
        return result;
    }

    public boolean authenticate(String userName, String password, String baseDN) {
        try {
            return this.ldapOperationService.authenticate(userName, password, baseDN);
        }
        catch (ConnectionException ex) {
            throw new AuthenticationException(String.format("Failed to authenticate user: %s", userName), ex);
        }
    }

    public boolean authenticate(String bindDn, String password) {
        try {
            return this.ldapOperationService.authenticate(bindDn, password);
        }
        catch (ConnectionException ex) {
            throw new AuthenticationException(String.format("Failed to authenticate dn: %s", bindDn), ex);
        }
    }

    public <T> int countEntries(Object entry) {
        if (entry == null) {
            throw new MappingException("Entry to count is null");
        }
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, false);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object dnValue = this.getDNValue(entry, entryClass);
        List<AttributeData> attributes = this.getAttributesListForPersist(entry, propertiesAnnotations);
        Filter searchFilter = this.createFilterByEntry(entry, entryClass, attributes);
        return this.countEntries(dnValue.toString(), entryClass, searchFilter);
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        String[] ldapReturnAttributes = new String[]{""};
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        int countEntries = 0;
        ASN1OctetString cookie = null;
        SearchResult searchResult = null;
        block2: do {
            Control[] controls = new Control[]{new SimplePagedResultsControl(100, cookie)};
            try {
                searchResult = this.ldapOperationService.search(baseDN, searchFilter, 0, 0, controls, ldapReturnAttributes);
                if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                    throw new EntryPersistenceException(String.format("Failed to calculate count entries with baseDN: %s, filter: %s", baseDN, searchFilter));
                }
            }
            catch (Exception ex) {
                throw new EntryPersistenceException(String.format("Failed to calculate count entries with baseDN: %s, filter: %s", baseDN, searchFilter), ex);
            }
            if ((countEntries += searchResult.getEntryCount()) == 0 || countEntries % 100 != 0) break;
            cookie = null;
            for (Control control : searchResult.getResponseControls()) {
                if (!(control instanceof SimplePagedResultsControl)) continue;
                cookie = ((SimplePagedResultsControl)control).getCookie();
                continue block2;
            }
        } while (cookie != null);
        return countEntries;
    }

    private <T> Filter createFilterByEntry(Object entry, Class<T> entryClass, List<AttributeData> attributes) {
        Filter[] attributesFilters = this.createAttributesFilter(attributes);
        Filter attributesFilter = null;
        if (attributesFilters != null) {
            attributesFilter = Filter.createANDFilter((Filter[])attributesFilters);
        }
        String[] objectClasses = this.getCustomObjectClasses(entry, entryClass);
        return this.addObjectClassFilter(attributesFilter, objectClasses);
    }

    public <T> void sortListByProperties(Class<T> entryClass, List<T> entries, boolean caseSensetive, String ... sortByProperties) {
        if (entries == null) {
            throw new MappingException("Entries list to sort is null");
        }
        if (entries.size() == 0) {
            return;
        }
        if (sortByProperties == null || sortByProperties.length == 0) {
            throw new InvalidArgumentException("Invalid list of sortBy properties " + Arrays.toString(sortByProperties));
        }
        Getter[][] propertyGetters = new Getter[sortByProperties.length][];
        for (int i = 0; i < sortByProperties.length; ++i) {
            String[] tmpProperties = sortByProperties[i].split("\\.");
            propertyGetters[i] = new Getter[tmpProperties.length];
            Class<Object> currentEntryClass = entryClass;
            for (int j = 0; j < tmpProperties.length; ++j) {
                if (j > 0) {
                    currentEntryClass = propertyGetters[i][j - 1].getReturnType();
                }
                propertyGetters[i][j] = this.getGetter(currentEntryClass, tmpProperties[j]);
            }
            if (propertyGetters[i][tmpProperties.length - 1] == null) {
                throw new MappingException("Entry should has getteres for all properties " + sortByProperties[i]);
            }
            Class<?> propertyType = propertyGetters[i][tmpProperties.length - 1].getReturnType();
            if (propertyType == String.class || propertyType == Date.class || propertyType == Integer.class || propertyType == Integer.TYPE) continue;
            throw new MappingException("Entry properties should has String, Date or Integer type. Property: '" + tmpProperties[tmpProperties.length - 1] + "'");
        }
        PropertyComparator comparator = new PropertyComparator(propertyGetters, caseSensetive);
        Collections.sort(entries, comparator);
    }

    @Override
    public <T> void sortListByProperties(Class<T> entryClass, List<T> entries, String ... sortByProperties) {
        this.sortListByProperties(entryClass, entries, false, sortByProperties);
    }

    public <T> Map<T, List<T>> groupListByProperties(Class<T> entryClass, List<T> entries, boolean caseSensetive, String groupByProperties, String sumByProperties) {
        if (entries == null) {
            throw new MappingException("Entries list to group is null");
        }
        if (entries.size() == 0) {
            return new HashMap(0);
        }
        if (StringHelper.isEmpty((String)groupByProperties)) {
            throw new InvalidArgumentException("List of groupBy properties is null");
        }
        Getter[] groupPropertyGetters = this.getEntryPropertyGetters(entryClass, groupByProperties, GROUP_BY_ALLOWED_DATA_TYPES);
        Setter[] groupPropertySetters = this.getEntryPropertySetters(entryClass, groupByProperties, GROUP_BY_ALLOWED_DATA_TYPES);
        Getter[] sumPropertyGetters = this.getEntryPropertyGetters(entryClass, sumByProperties, SUM_BY_ALLOWED_DATA_TYPES);
        Setter[] sumPropertySetter = this.getEntryPropertySetters(entryClass, sumByProperties, SUM_BY_ALLOWED_DATA_TYPES);
        return this.groupListByPropertiesImpl(entryClass, entries, caseSensetive, groupPropertyGetters, groupPropertySetters, sumPropertyGetters, sumPropertySetter);
    }

    private <T> Getter[] getEntryPropertyGetters(Class<T> entryClass, String properties, Class<?>[] allowedTypes) {
        if (StringHelper.isEmpty((String)properties)) {
            return null;
        }
        String[] tmpProperties = properties.split("\\,");
        Getter[] propertyGetters = new Getter[tmpProperties.length];
        for (int i = 0; i < tmpProperties.length; ++i) {
            propertyGetters[i] = this.getGetter(entryClass, tmpProperties[i].trim());
            if (propertyGetters[i] == null) {
                throw new MappingException("Entry should has getter for property " + tmpProperties[i]);
            }
            Class<?> returnType = propertyGetters[i].getReturnType();
            boolean found = false;
            for (Class<?> clazz : allowedTypes) {
                if (!ReflectHelper.assignableFrom(returnType, clazz)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new MappingException("Entry property getter should has next data types " + Arrays.toString(allowedTypes));
        }
        return propertyGetters;
    }

    private <T> Setter[] getEntryPropertySetters(Class<T> entryClass, String properties, Class<?>[] allowedTypes) {
        if (StringHelper.isEmpty((String)properties)) {
            return null;
        }
        String[] tmpProperties = properties.split("\\,");
        Setter[] propertySetters = new Setter[tmpProperties.length];
        for (int i = 0; i < tmpProperties.length; ++i) {
            propertySetters[i] = this.getSetter(entryClass, tmpProperties[i].trim());
            if (propertySetters[i] == null) {
                throw new MappingException("Entry should has setter for property " + tmpProperties[i]);
            }
            Class<?> paramType = ReflectHelper.getSetterType(propertySetters[i]);
            boolean found = false;
            for (Class<?> clazz : allowedTypes) {
                if (!ReflectHelper.assignableFrom(paramType, clazz)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new MappingException("Entry property setter should has next data types " + Arrays.toString(allowedTypes));
        }
        return propertySetters;
    }

    public <T> Map<T, List<T>> groupListByProperties(Class<T> entryClass, List<T> entries, String groupByProperties, String sumByProperties) {
        return this.groupListByProperties(entryClass, entries, false, groupByProperties, sumByProperties);
    }

    private <T> Map<T, List<T>> groupListByPropertiesImpl(Class<T> entryClass, List<T> entries, boolean caseSensetive, Getter[] groupPropertyGetters, Setter[] groupPropertySetters, Getter[] sumProperyGetters, Setter[] sumPropertySetter) {
        HashMap keys = new HashMap();
        IdentityHashMap groups = new IdentityHashMap();
        for (T entry : entries) {
            ArrayList<T> groupValues;
            String key = this.getEntryKey(entry, caseSensetive, groupPropertyGetters);
            Object entryKey = keys.get(key);
            if (entryKey == null) {
                try {
                    entryKey = ReflectHelper.createObjectByDefaultConstructor(entryClass);
                }
                catch (Exception ex) {
                    throw new MappingException(String.format("Entry %s should has default constructor", entryClass), ex);
                }
                try {
                    ReflectHelper.copyObjectPropertyValues(entry, entryKey, groupPropertyGetters, groupPropertySetters);
                }
                catch (Exception ex) {
                    throw new MappingException("Failed to set values in group Entry", ex);
                }
                keys.put(key, entryKey);
            }
            if ((groupValues = (ArrayList<T>)groups.get(entryKey)) == null) {
                groupValues = new ArrayList<T>();
                groups.put(entryKey, groupValues);
            }
            try {
                if (sumProperyGetters != null) {
                    ReflectHelper.sumObjectPropertyValues(entryKey, entry, sumProperyGetters, sumPropertySetter);
                }
            }
            catch (Exception ex) {
                throw new MappingException("Failed to sum values in group Entry", ex);
            }
            groupValues.add(entry);
        }
        return groups;
    }

    @Override
    public String encodeGeneralizedTime(Date date) {
        if (date == null) {
            return null;
        }
        return StaticUtils.encodeGeneralizedTime((Date)date);
    }

    @Override
    public Date decodeGeneralizedTime(String date) {
        if (date == null) {
            return null;
        }
        try {
            return StaticUtils.decodeGeneralizedTime((String)date);
        }
        catch (ParseException ex) {
            log.error("Failed to parse generalized time {}", (Object)date, (Object)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadLdifFileContent(String ldifFileContent) {
        LDAPConnection connection = null;
        try {
            connection = this.ldapOperationService.getConnection();
            ResultCode result = LdifDataUtility.instance().importLdifFileContent(connection, ldifFileContent);
            boolean bl = ResultCode.SUCCESS.equals((Object)result);
            return bl;
        }
        catch (Exception ex) {
            log.error("Failed to load ldif file", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                this.ldapOperationService.releaseConnection(connection);
            }
        }
    }

    public String[] getLDIF(String dn) {
        String[] ldif = null;
        try {
            ldif = this.ldapOperationService.lookup(dn).toLDIF();
        }
        catch (ConnectionException e) {
            log.error("Failed get ldif from " + dn, (Throwable)e);
        }
        return ldif;
    }

    public List<String[]> getLDIF(String dn, String[] attributes) {
        SearchResult searchResult;
        try {
            searchResult = this.ldapOperationService.search(dn, Filter.create((String)"objectclass=*"), SearchScope.BASE, -1, 0, null, attributes);
            if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s", dn));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", dn, null), ex);
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (searchResult.getEntryCount() == 0) {
            return result;
        }
        for (SearchResultEntry searchResultEntry : searchResult.getSearchEntries()) {
            result.add(searchResultEntry.toLDIF());
        }
        return result;
    }

    public List<String[]> getLDIFTree(String baseDN, Filter searchFilter, String ... attributes) {
        SearchResult searchResult;
        try {
            searchResult = this.ldapOperationService.search(baseDN, searchFilter, -1, 0, null, attributes);
            if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter), ex);
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (searchResult.getEntryCount() == 0) {
            return result;
        }
        for (SearchResultEntry searchResultEntry : searchResult.getSearchEntries()) {
            result.add(searchResultEntry.toLDIF());
        }
        return result;
    }

    @Override
    public int getSupportedLDAPVersion() {
        return this.ldapOperationService.getSupportedLDAPVersion();
    }

    private static final class LineLenghtComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 575848841116711467L;
        private boolean ascending;

        public LineLenghtComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(T entry1, T entry2) {
            if (entry1 == null && entry2 == null) {
                return 0;
            }
            if (entry1 == null && entry2 != null) {
                return -1;
            }
            if (entry1 != null && entry2 == null) {
                return 1;
            }
            int result = entry1.toString().length() - entry2.toString().length();
            if (this.ascending) {
                return result;
            }
            return -result;
        }
    }

    private static final class PropertyComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 574848841116711467L;
        private Getter[][] propertyGetters;
        private boolean caseSensetive;

        private PropertyComparator(Getter[][] propertyGetters, boolean caseSensetive) {
            this.propertyGetters = propertyGetters;
            this.caseSensetive = caseSensetive;
        }

        @Override
        public int compare(T entry1, T entry2) {
            Getter[] curPropertyGetters;
            if (entry1 == null && entry2 == null) {
                return 0;
            }
            if (entry1 == null && entry2 != null) {
                return -1;
            }
            if (entry1 != null && entry2 == null) {
                return 1;
            }
            int result = 0;
            Getter[][] arr$ = this.propertyGetters;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (result = this.compare(entry1, entry2, curPropertyGetters = arr$[i$])) == 0; ++i$) {
            }
            return result;
        }

        public int compare(T entry1, T entry2, Getter[] propertyGetters) {
            Object value1 = ReflectHelper.getPropertyValue(entry1, propertyGetters);
            Object value2 = ReflectHelper.getPropertyValue(entry2, propertyGetters);
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            if (value1 instanceof Date) {
                return ((Date)value1).compareTo((Date)value2);
            }
            if (value1 instanceof Integer) {
                return ((Integer)value1).compareTo((Integer)value2);
            }
            if (value1 instanceof String && value2 instanceof String) {
                if (this.caseSensetive) {
                    return ((String)value1).compareTo((String)value2);
                }
                return ((String)value1).toLowerCase().compareTo(((String)value2).toLowerCase());
            }
            return 0;
        }
    }
}

