/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap.persistence;

import java.util.Arrays;
import org.xdi.util.ArrayHelper;
import org.xdi.util.StringHelper;

public class AttributeData {
    private final String name;
    private final String[] values;

    public AttributeData(String name, String[] values) {
        this.name = name;
        this.values = values;
    }

    public AttributeData(String name, String value) {
        this.name = name;
        this.values = new String[1];
        this.values[0] = value;
    }

    public final String getName() {
        return this.name;
    }

    public final String[] getValues() {
        return this.values;
    }

    public String getValue() {
        if (this.values == null || this.values.length == 0) {
            return null;
        }
        return this.values[0];
    }

    public boolean isEmpty() {
        if (this.values == null || this.values.length == 0) {
            return true;
        }
        for (String val : this.values) {
            if (!StringHelper.isEmpty((String)val)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeData other = (AttributeData)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return ArrayHelper.equalsIgnoreOrder((String[])this.values, (String[])other.values);
    }

    public String toString() {
        return String.format("Attribute [name=%s, values=%s]", this.name, Arrays.toString(this.values));
    }
}

