/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;
import org.xdi.util.ArrayHelper;
import org.xdi.util.StringHelper;

public class LDAPConnectionProvider {
    private static final Logger log = Logger.getLogger(LDAPConnectionProvider.class);
    private static final int DEFAULT_SUPPORTED_LDAP_VERSION = 2;
    private static final String[] SSL_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"};
    private LDAPConnectionPool connectionPool;
    private ResultCode creationResultCode;
    private int supportedLDAPVersion = 2;
    private String[] servers;
    private String[] addresses;
    private int[] ports;
    private String bindDn;
    private String bindPassword;
    private boolean useSSL;
    private ArrayList<String> binaryAttributes;

    private LDAPConnectionProvider() {
    }

    public LDAPConnectionProvider(Properties props) {
        try {
            this.init(props);
        }
        catch (LDAPException ex) {
            this.creationResultCode = ex.getResultCode();
            log.error((Object)("Failed to create connection pool with properties: " + props), (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)("Failed to create connection pool with properties: " + props), (Throwable)ex);
        }
    }

    public void init(Properties props) throws NumberFormatException, LDAPException, GeneralSecurityException {
        block9: {
            String serverProp = props.getProperty("servers");
            this.servers = serverProp.split(",");
            this.addresses = new String[this.servers.length];
            this.ports = new int[this.servers.length];
            for (int i = 0; i < this.servers.length; ++i) {
                String str = this.servers[i];
                this.addresses[i] = str.substring(0, str.indexOf(":")).trim();
                this.ports[i] = Integer.parseInt(str.substring(str.indexOf(":") + 1, str.length()));
            }
            SimpleBindRequest bindRequest = null;
            if (StringHelper.isEmpty((String)props.getProperty("bindDN"))) {
                this.bindDn = null;
                this.bindPassword = null;
                bindRequest = new SimpleBindRequest();
            } else {
                this.bindDn = props.getProperty("bindDN");
                this.bindPassword = props.getProperty("bindPassword");
                bindRequest = new SimpleBindRequest(this.bindDn, this.bindPassword);
            }
            LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
            connectionOptions.setConnectTimeoutMillis(100000);
            connectionOptions.setAutoReconnect(true);
            this.useSSL = Boolean.valueOf(props.getProperty("useSSL"));
            SSLUtil sslUtil = new SSLUtil((TrustManager)new TrustAllTrustManager());
            FailoverServerSet failoverSet = this.useSSL ? new FailoverServerSet(this.addresses, this.ports, (SocketFactory)sslUtil.createSSLSocketFactory(SSL_PROTOCOLS[0]), connectionOptions) : new FailoverServerSet(this.addresses, this.ports, connectionOptions);
            int maxConnections = Integer.parseInt(props.getProperty("maxconnections"));
            try {
                this.connectionPool = new LDAPConnectionPool((ServerSet)failoverSet, (BindRequest)bindRequest, maxConnections);
            }
            catch (LDAPException ex) {
                if (!this.useSSL) {
                    throw ex;
                }
                log.info((Object)"Attempting to use older SSL protocols", (Throwable)ex);
                this.connectionPool = this.createSSLConnectionPoolWithPreviousProtocols(sslUtil, (BindRequest)bindRequest, connectionOptions, maxConnections);
                if (this.connectionPool != null) break block9;
                throw ex;
            }
        }
        if (this.connectionPool != null) {
            this.connectionPool.setCreateIfNecessary(true);
            String connectionMaxWaitTime = props.getProperty("connection-max-wait-time");
            if (StringHelper.isNotEmpty((String)connectionMaxWaitTime)) {
                this.connectionPool.setMaxWaitTimeMillis(Long.parseLong(connectionMaxWaitTime));
            }
        }
        this.binaryAttributes = new ArrayList();
        if (props.containsKey("binaryAttributes")) {
            String[] binaryAttrs = StringHelper.split((String)props.get("binaryAttributes").toString().toLowerCase(), (String)",");
            this.binaryAttributes.addAll(Arrays.asList(binaryAttrs));
        }
        log.debug((Object)("Using next binary attributes: " + this.binaryAttributes));
        this.supportedLDAPVersion = this.determineSupportedLdapVersion();
        this.creationResultCode = ResultCode.SUCCESS;
    }

    private LDAPConnectionPool createSSLConnectionPoolWithPreviousProtocols(SSLUtil sslUtil, BindRequest bindRequest, LDAPConnectionOptions connectionOptions, int maxConnections) {
        for (int i = 1; i < SSL_PROTOCOLS.length; ++i) {
            String protocol = SSL_PROTOCOLS[i];
            try {
                FailoverServerSet failoverSet = new FailoverServerSet(this.addresses, this.ports, (SocketFactory)sslUtil.createSSLSocketFactory(protocol), connectionOptions);
                LDAPConnectionPool connectionPool = new LDAPConnectionPool((ServerSet)failoverSet, bindRequest, maxConnections);
                log.info((Object)("Server supports: '" + protocol + "'"));
                return connectionPool;
            }
            catch (GeneralSecurityException ex) {
                log.debug((Object)("Server not supports: '" + protocol + "'"), (Throwable)ex);
                continue;
            }
            catch (LDAPException ex) {
                log.debug((Object)("Server not supports: '" + protocol + "'"), (Throwable)ex);
            }
        }
        return null;
    }

    private int determineSupportedLdapVersion() {
        int resultSupportedLDAPVersion = 2;
        if (StringHelper.isEmptyString((Object)this.bindDn) || StringHelper.isEmptyString((Object)this.bindPassword)) {
            return resultSupportedLDAPVersion;
        }
        if (this.connectionPool == null) {
            return resultSupportedLDAPVersion;
        }
        try {
            Object[] supportedLDAPVersions = this.connectionPool.getRootDSE().getAttributeValues("supportedLDAPVersion");
            if (ArrayHelper.isEmpty((Object[])supportedLDAPVersions)) {
                return resultSupportedLDAPVersion;
            }
            for (Object supportedLDAPVersion : supportedLDAPVersions) {
                resultSupportedLDAPVersion = Math.max(resultSupportedLDAPVersion, Integer.parseInt((String)supportedLDAPVersion));
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to determine supportedLDAPVersion", (Throwable)ex);
        }
        return resultSupportedLDAPVersion;
    }

    public int getSupportedLDAPVersion() {
        return this.supportedLDAPVersion;
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.connectionPool.getConnection();
    }

    public void releaseConnection(LDAPConnection connection) {
        this.connectionPool.releaseConnection(connection);
    }

    public void releaseConnection(LDAPConnection connection, LDAPException ex) {
        this.connectionPool.releaseConnectionAfterException(connection, ex);
    }

    public void closeDefunctConnection(LDAPConnection connection) {
        this.connectionPool.releaseDefunctConnection(connection);
    }

    public LDAPConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void closeConnectionPool() {
        this.connectionPool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        if (this.connectionPool == null) {
            return false;
        }
        boolean isConnected = false;
        try {
            LDAPConnection connection = this.getConnection();
            try {
                isConnected = connection.isConnected();
            }
            finally {
                this.releaseConnection(connection);
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        return isConnected;
    }

    public ResultCode getCreationResultCode() {
        return this.creationResultCode;
    }

    public void setCreationResultCode(ResultCode creationResultCode) {
        this.creationResultCode = creationResultCode;
    }

    public String[] getServers() {
        return this.servers;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public ArrayList<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public boolean isBinaryAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return false;
        }
        return this.binaryAttributes.contains(attributeName.toLowerCase());
    }
}

