/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.ldap.model;

import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

public class CustomAttribute
implements Serializable,
Comparable<CustomAttribute> {
    private static final long serialVersionUID = 1468440094325406153L;
    private String name;
    private String[] values;

    public CustomAttribute() {
    }

    public CustomAttribute(String name, String value) {
        this.name = name;
        this.setValue(value);
    }

    public CustomAttribute(String name, Date value) {
        this.name = name;
        this.setDate(value);
    }

    public CustomAttribute(String name, String[] values) {
        this.name = name;
        this.values = values;
    }

    public CustomAttribute(String name, Set<String> values) {
        this.name = name;
        this.values = values.toArray(new String[0]);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        if (this.values == null) {
            return null;
        }
        if (this.values.length > 0) {
            return this.values[0];
        }
        return null;
    }

    public void setValue(String value) {
        if (this.values == null) {
            this.values = new String[0];
        }
        if (this.values.length != 1) {
            this.values = new String[1];
        }
        this.values[0] = value;
    }

    public Date getDate() {
        if (this.values == null) {
            return null;
        }
        if (this.values.length > 0 && this.values[0] != null) {
            try {
                return StaticUtils.decodeGeneralizedTime((String)this.values[0]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(Date date) {
        if (this.values == null) {
            this.values = new String[0];
        }
        if (this.values.length != 1) {
            this.values = new String[1];
        }
        this.values[0] = StaticUtils.encodeGeneralizedTime((Date)date);
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public void setValues(Collection<String> values) {
        this.values = values.toArray(new String[0]);
    }

    public void setValues(Set<String> values) {
        this.values = values.toArray(new String[0]);
    }

    public String getDisplayValue() {
        if (this.values == null) {
            return "";
        }
        if (this.values.length == 1) {
            return this.values[0];
        }
        StringBuilder sb = new StringBuilder(this.values[0]);
        for (int i = 1; i < this.values.length; ++i) {
            sb.append(", ").append(this.values[i]);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomAttribute that = (CustomAttribute)o;
        return !(this.name == null ? that.name != null : !this.name.equalsIgnoreCase(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return String.format("Attribute [name=%s, values=%s]", this.name, Arrays.toString(this.values));
    }

    @Override
    public int compareTo(CustomAttribute o) {
        return this.name.compareTo(o.name);
    }
}

