/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.SubtreeDeleteRequestControl;
import com.unboundid.ldif.LDIFChangeRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.exception.ConnectionException;
import org.gluu.site.ldap.exception.DuplicateEntryException;
import org.xdi.util.ArrayHelper;

public class OperationsFacade {
    public static final String dn = "dn";
    public static final String uid = "uid";
    public static final String success = "success";
    public static final String userPassword = "userPassword";
    public static final String objectClass = "objectClass";
    private LDAPConnectionProvider connectionProvider;
    private LDAPConnectionProvider bindConnectionProvider;
    private static final Logger log = Logger.getLogger(OperationsFacade.class);

    private OperationsFacade() {
    }

    @Deprecated
    public OperationsFacade(LDAPConnectionProvider connectionProvider) {
        this(connectionProvider, null);
    }

    public OperationsFacade(LDAPConnectionProvider connectionProvider, LDAPConnectionProvider bindConnectionProvider) {
        this.connectionProvider = connectionProvider;
        this.bindConnectionProvider = bindConnectionProvider;
    }

    public LDAPConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(LDAPConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public LDAPConnectionProvider getBindConnectionProvider() {
        return this.bindConnectionProvider;
    }

    public void setBindConnectionProvider(LDAPConnectionProvider bindConnectionProvider) {
        this.bindConnectionProvider = bindConnectionProvider;
    }

    public LDAPConnectionPool getConnectionPool() {
        return this.connectionProvider.getConnectionPool();
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.connectionProvider.getConnection();
    }

    public void releaseConnection(LDAPConnection connection) {
        this.connectionProvider.releaseConnection(connection);
    }

    public boolean authenticate(String userName, String password, String baseDN) throws ConnectionException {
        try {
            return this.authenticateImpl(userName, password, baseDN);
        }
        catch (LDAPException ex) {
            throw new ConnectionException("Failed to authenticate user", (Exception)((Object)ex));
        }
    }

    public boolean authenticate(String bindDn, String password) throws ConnectionException {
        try {
            return this.authenticateImpl(bindDn, password);
        }
        catch (LDAPException ex) {
            throw new ConnectionException("Failed to authenticate dn", (Exception)((Object)ex));
        }
    }

    private boolean authenticateImpl(String userName, String password, String baseDN) throws LDAPException, ConnectionException {
        return this.authenticateImpl(this.lookupDnByUid(userName, baseDN), password);
    }

    private boolean authenticateImpl(String bindDn, String password) throws LDAPException, ConnectionException {
        if (this.bindConnectionProvider == null) {
            return this.authenticateConnectionPoolImpl(bindDn, password);
        }
        return this.authenticateBindConnectionPoolImpl(bindDn, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateConnectionPoolImpl(String bindDn, String password) throws LDAPException, ConnectionException {
        boolean loggedIn = false;
        if (bindDn == null) {
            return loggedIn;
        }
        boolean closeConnection = false;
        LDAPConnection connection = this.connectionProvider.getConnection();
        try {
            closeConnection = true;
            BindResult r = connection.bind(bindDn, password);
            if (r.getResultCode() == ResultCode.SUCCESS) {
                loggedIn = true;
            }
        }
        finally {
            this.connectionProvider.releaseConnection(connection);
            if (closeConnection) {
                this.connectionProvider.closeDefunctConnection(connection);
            }
        }
        return loggedIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateBindConnectionPoolImpl(String bindDn, String password) throws LDAPException, ConnectionException {
        if (bindDn == null) {
            return false;
        }
        LDAPConnection connection = this.bindConnectionProvider.getConnection();
        try {
            BindResult r = connection.bind(bindDn, password);
            boolean bl = r.getResultCode() == ResultCode.SUCCESS;
            return bl;
        }
        finally {
            this.bindConnectionProvider.releaseConnection(connection);
        }
    }

    protected String lookupDnByUid(String uid, String baseDN) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter((String)uid, (String)uid);
        SearchResult searchResult = this.search(baseDN, filter, 1);
        if (searchResult != null && searchResult.getEntryCount() > 0) {
            return ((SearchResultEntry)searchResult.getSearchEntries().get(0)).getDN();
        }
        return null;
    }

    public SearchResult search(String dn, Filter filter, int sizeLimit) throws LDAPSearchException {
        return this.search(dn, filter, sizeLimit, null, (String[])null);
    }

    public SearchResult search(String dn, Filter filter, int sizeLimit, Control[] controls, String ... attributes) throws LDAPSearchException {
        return this.search(dn, filter, SearchScope.SUB, sizeLimit, controls, attributes);
    }

    public SearchResult search(String dn, Filter filter, SearchScope scope, int sizeLimit, Control[] controls, String ... attributes) throws LDAPSearchException {
        SearchRequest searchRequest = attributes == null ? new SearchRequest(dn, scope, filter, new String[0]) : new SearchRequest(dn, scope, filter, attributes);
        SearchResult searchResult = null;
        ArrayList<SearchResult> searchResultList = new ArrayList<SearchResult>();
        ArrayList searchResultEntries = new ArrayList();
        ArrayList searchResultReferences = new ArrayList();
        if (sizeLimit > 0) {
            ASN1OctetString cookie = null;
            do {
                searchRequest.setControls(new Control[]{new SimplePagedResultsControl(sizeLimit, cookie)});
                this.setControls(searchRequest, controls);
                searchResult = this.getConnectionPool().search(searchRequest);
                searchResultList.add(searchResult);
                searchResultEntries.addAll(searchResult.getSearchEntries());
                searchResultReferences.addAll(searchResult.getSearchReferences());
                cookie = null;
                try {
                    SimplePagedResultsControl c = SimplePagedResultsControl.get((SearchResult)searchResult);
                    if (c == null) continue;
                    cookie = c.getCookie();
                }
                catch (LDAPException ex) {
                    log.error((Object)("Error while accessing cookies" + ex.getMessage()));
                }
            } while (cookie != null && cookie.getValueLength() > 0);
            SearchResult searchResultTemp = (SearchResult)searchResultList.get(0);
            searchResult = new SearchResult(searchResultTemp.getMessageID(), searchResultTemp.getResultCode(), searchResultTemp.getDiagnosticMessage(), searchResultTemp.getMatchedDN(), searchResultTemp.getReferralURLs(), searchResultEntries, searchResultReferences, searchResultEntries.size(), searchResultReferences.size(), searchResultTemp.getResponseControls());
        } else {
            this.setControls(searchRequest, controls);
            searchResult = this.getConnectionPool().search(searchRequest);
        }
        return searchResult;
    }

    private void setControls(SearchRequest searchRequest, Control ... controls) {
        if (!ArrayHelper.isEmpty((Object[])controls)) {
            Control[] newControls = ArrayHelper.isEmpty((Object[])searchRequest.getControls()) ? controls : (Control[])ArrayHelper.arrayMerge((Object[][])new Control[][]{searchRequest.getControls(), controls});
            searchRequest.setControls(newControls);
        }
    }

    public SearchResultEntry lookup(String dn) throws ConnectionException {
        return this.lookup(dn, null);
    }

    public SearchResultEntry lookup(String dn, String ... attributes) throws ConnectionException {
        try {
            if (attributes == null) {
                return this.getConnectionPool().getEntry(dn);
            }
            return this.getConnectionPool().getEntry(dn, attributes);
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to lookup entry", ex);
        }
    }

    public boolean addEntry(String dn, Collection<Attribute> atts) throws DuplicateEntryException, ConnectionException {
        try {
            LDAPResult result = this.getConnectionPool().add(dn, atts);
            if (result.getResultCode().getName().equalsIgnoreCase(success)) {
                return true;
            }
        }
        catch (LDAPException ex) {
            int errorCode = ex.getResultCode().intValue();
            if (errorCode == 68) {
                throw new DuplicateEntryException();
            }
            if (errorCode == 50) {
                throw new ConnectionException("LDAP config error: insufficient access rights.", (Exception)((Object)ex));
            }
            if (errorCode == 3) {
                throw new ConnectionException("LDAP Error: time limit exceeded", (Exception)((Object)ex));
            }
            if (errorCode == 65) {
                throw new ConnectionException("LDAP config error: schema violation contact LDAP admin.", (Exception)((Object)ex));
            }
            throw new ConnectionException("Error adding object to directory. LDAP error number " + errorCode, (Exception)((Object)ex));
        }
        return false;
    }

    public boolean updateEntry(String dn, Collection<Attribute> attrs) throws LDAPException {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        for (Attribute attribute : attrs) {
            if (attribute.getName().equalsIgnoreCase(objectClass) || attribute.getName().equalsIgnoreCase(dn) || attribute.getName().equalsIgnoreCase(userPassword) || attribute.getName() == null || attribute.getValue() == null) continue;
            mods.add(new Modification(ModificationType.REPLACE, attribute.getName(), attribute.getValue()));
        }
        return this.updateEntry(dn, (List<Modification>)mods);
    }

    public boolean updateEntry(String dn, List<Modification> modifications) throws LDAPException {
        ModifyRequest modifyRequest = new ModifyRequest(dn, modifications);
        return this.modifyEntry(modifyRequest);
    }

    protected boolean modifyEntry(ModifyRequest modifyRequest) throws LDAPException {
        LDAPResult modifyResult = null;
        try {
            modifyResult = this.getConnectionPool().modify(modifyRequest);
            return ResultCode.SUCCESS.equals((Object)modifyResult.getResultCode());
        }
        catch (LDAPException e) {
            log.error((Object)"Entry can't be modified", (Throwable)e);
            return false;
        }
    }

    public void delete(String dn) throws ConnectionException {
        try {
            this.getConnectionPool().delete(dn);
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to delete entry", ex);
        }
    }

    public void deleteWithSubtree(String dn) throws ConnectionException {
        try {
            DeleteRequest deleteRequest = new DeleteRequest(dn);
            deleteRequest.addControl((Control)new SubtreeDeleteRequestControl());
            this.getConnectionPool().delete(deleteRequest);
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to delete entry", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processChange(LDIFChangeRecord ldifRecord) throws LDAPException {
        LDAPConnection connection = this.getConnection();
        try {
            LDAPResult ldapResult = ldifRecord.processChange((LDAPInterface)connection);
            boolean bl = ResultCode.SUCCESS.equals((Object)ldapResult.getResultCode());
            return bl;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    public int getSupportedLDAPVersion() {
        return this.connectionProvider.getSupportedLDAPVersion();
    }
}

