/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap.persistence;

import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public final class LdifDataUtility {
    private static final Logger log = Logger.getLogger(LdifDataUtility.class);

    private LdifDataUtility() {
    }

    public static LdifDataUtility instance() {
        return Holder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode importLdifFile(LDAPConnection connection, String ldifFileName) {
        LDIFReader ldifReader = this.createLdifReader(ldifFileName);
        if (ldifReader == null) {
            return ResultCode.LOCAL_ERROR;
        }
        try {
            ResultCode resultCode = this.importLdifFile(connection, ldifReader);
            return resultCode;
        }
        finally {
            this.disposeLdifReader(ldifReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode importLdifFileContent(LDAPConnection connection, String ldifFileContent) {
        ResultCode resultCode;
        BufferedReader is = null;
        LDIFReader ldifReader = null;
        try {
            is = new BufferedReader(new StringReader(ldifFileContent));
            ldifReader = new LDIFReader(is);
            resultCode = this.importLdifFile(connection, ldifReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            if (ldifReader != null) {
                this.disposeLdifReader(ldifReader);
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        if (ldifReader != null) {
            this.disposeLdifReader(ldifReader);
        }
        return resultCode;
    }

    protected ResultCode importLdifFile(LDAPConnection connection, LDIFReader ldifReader) {
        ResultCode resultCode = ResultCode.SUCCESS;
        while (true) {
            LDIFChangeRecord ldifRecord = null;
            try {
                ldifRecord = ldifReader.readChangeRecord(true);
            }
            catch (LDIFException le) {
                log.error((Object)"Malformed ldif record", (Throwable)le);
                if (!le.mayContinueReading()) {
                    resultCode = ResultCode.DECODING_ERROR;
                    break;
                }
            }
            catch (IOException ioe) {
                log.error((Object)"I/O error encountered while reading a change record", (Throwable)ioe);
                resultCode = ResultCode.LOCAL_ERROR;
                break;
            }
            if (ldifRecord == null) break;
            try {
                ldifRecord.processChange((LDAPInterface)connection);
            }
            catch (LDAPException le) {
                if (ResultCode.ENTRY_ALREADY_EXISTS.equals((Object)le.getResultCode()) || ldifRecord.getChangeType().equals((Object)ChangeType.DELETE)) continue;
                log.error((Object)"Failed to inserting ldif record", (Throwable)le);
            }
        }
        return resultCode;
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkIfSerrverHasEntryFromLDIFFile(LDAPConnection connection, String ldifFileName) {
        ldifReader = this.createLdifReader(ldifFileName);
        if (ldifReader == null) {
            return true;
        }
        while (true) {
            entry = null;
            try {
                entry = ldifReader.readEntry();
            }
            catch (LDIFException le) {
                LdifDataUtility.log.error((Object)"Malformed ldif record", (Throwable)le);
                if (!le.mayContinueReading()) {
                    return true;
                }
            }
            catch (IOException ioe) {
                LdifDataUtility.log.error((Object)"I/O error encountered while reading a change record", (Throwable)ioe);
                return true;
            }
            if (entry == null) break;
            try {
                sr = connection.search(entry.getDN(), SearchScope.BASE, "objectClass=*", new String[0]);
                if (sr == null || sr.getEntryCount() <= 0) continue;
                return true;
            }
            catch (LDAPException le) {
                if (le.getResultCode() != ResultCode.NO_SUCH_OBJECT) ** break;
                continue;
                LdifDataUtility.log.error((Object)"Failed to search ldif record", (Throwable)le);
                return true;
            }
            break;
        }
        this.disposeLdifReader(ldifReader);
        return false;
    }

    public ResultCode deleteEntryWithAllSubs(LDAPConnection connection, String baseDN) {
        ResultCode resultCode = ResultCode.SUCCESS;
        SearchResult searchResult = null;
        try {
            searchResult = connection.search(baseDN, SearchScope.SUB, "objectClass=*", new String[0]);
            if (searchResult == null || searchResult.getEntryCount() == 0) {
                return ResultCode.LOCAL_ERROR;
            }
        }
        catch (LDAPSearchException le) {
            log.error((Object)"Failed to search subordinate entries", (Throwable)le);
            return ResultCode.LOCAL_ERROR;
        }
        LinkedList<String> dns = new LinkedList<String>();
        for (SearchResultEntry entry : searchResult.getSearchEntries()) {
            dns.add(entry.getDN());
        }
        ListIterator listIterator = dns.listIterator(dns.size());
        while (listIterator.hasPrevious()) {
            try {
                connection.delete((String)listIterator.previous());
            }
            catch (LDAPException le) {
                log.error((Object)"Failed to delete entry", (Throwable)le);
                resultCode = ResultCode.LOCAL_ERROR;
                break;
            }
        }
        return resultCode;
    }

    private LDIFReader createLdifReader(String ldifFileNamePath) {
        LDIFReader ldifReader;
        File ldifFile = new File(ldifFileNamePath);
        try {
            if (!ldifFile.exists()) {
                return null;
            }
            ldifReader = new LDIFReader(ldifFile);
        }
        catch (IOException ex) {
            log.error((Object)"I/O error creating the LDIF reader", (Throwable)ex);
            return null;
        }
        return ldifReader;
    }

    private void disposeLdifReader(LDIFReader ldifReader) {
        if (ldifReader != null) {
            try {
                ldifReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class Holder {
        static LdifDataUtility instance = new LdifDataUtility();

        private Holder() {
        }
    }
}

