/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;
import org.xdi.util.ArrayHelper;
import org.xdi.util.StringHelper;

public class LDAPConnectionProvider {
    private static final Logger log = Logger.getLogger(LDAPConnectionProvider.class);
    public static final String bindPassword = "bindPassword";
    private static final int DEFAULT_SUPPORTED_LDAP_VERSION = 2;
    private LDAPConnectionPool connectionPool;
    private int supportedLDAPVersion = 2;

    private LDAPConnectionProvider() {
    }

    public LDAPConnectionProvider(Properties props) {
        try {
            this.init(props);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to create connection pool", (Throwable)ex);
        }
    }

    public void init(Properties props) throws NumberFormatException, LDAPException, GeneralSecurityException {
        FailoverServerSet failoverSet;
        String serverProp = props.getProperty("servers");
        String[] servers = serverProp.split(",");
        String[] addresses = new String[servers.length];
        int[] ports = new int[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            String str = servers[i];
            addresses[i] = str.substring(0, str.indexOf(":")).trim();
            ports[i] = Integer.parseInt(str.substring(str.indexOf(":") + 1, str.length()));
        }
        SimpleBindRequest bindRequest = null;
        bindRequest = StringHelper.isEmpty((String)props.getProperty("bindDN")) ? new SimpleBindRequest() : new SimpleBindRequest(props.getProperty("bindDN"), props.getProperty(bindPassword));
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setConnectTimeoutMillis(100000);
        connectionOptions.setAutoReconnect(true);
        boolean useSSL = Boolean.valueOf(props.getProperty("useSSL"));
        if (useSSL) {
            SSLUtil sslUtil = new SSLUtil((TrustManager)new TrustAllTrustManager());
            failoverSet = new FailoverServerSet(addresses, ports, (SocketFactory)sslUtil.createSSLSocketFactory(), connectionOptions);
        } else {
            failoverSet = new FailoverServerSet(addresses, ports, connectionOptions);
        }
        this.connectionPool = new LDAPConnectionPool((ServerSet)failoverSet, (BindRequest)bindRequest, Integer.parseInt(props.getProperty("maxconnections")));
        if (this.connectionPool != null) {
            this.connectionPool.setCreateIfNecessary(true);
        }
        this.supportedLDAPVersion = this.determineSupportedLdapVersion();
    }

    private int determineSupportedLdapVersion() {
        int resultSupportedLDAPVersion = 2;
        if (this.connectionPool == null) {
            return resultSupportedLDAPVersion;
        }
        try {
            Object[] supportedLDAPVersions = this.connectionPool.getRootDSE().getAttributeValues("supportedLDAPVersion");
            if (ArrayHelper.isEmpty((Object[])supportedLDAPVersions)) {
                return resultSupportedLDAPVersion;
            }
            for (Object supportedLDAPVersion : supportedLDAPVersions) {
                resultSupportedLDAPVersion = Math.max(resultSupportedLDAPVersion, Integer.parseInt((String)supportedLDAPVersion));
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to determine supportedLDAPVersion", (Throwable)ex);
        }
        return resultSupportedLDAPVersion;
    }

    public int getSupportedLDAPVersion() {
        return this.supportedLDAPVersion;
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.connectionPool.getConnection();
    }

    public void releaseConnection(LDAPConnection connection) {
        this.connectionPool.releaseConnection(connection);
    }

    public void releaseConnection(LDAPConnection connection, LDAPException ex) {
        this.connectionPool.releaseConnectionAfterException(connection, ex);
    }

    public void closeDefunctConnection(LDAPConnection connection) {
        this.connectionPool.releaseDefunctConnection(connection);
    }

    public LDAPConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void closeConnectionPool() {
        this.connectionPool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        if (this.connectionPool == null) {
            return false;
        }
        boolean isConnected = false;
        try {
            LDAPConnection connection = this.getConnection();
            try {
                isConnected = connection.isConnected();
            }
            finally {
                this.releaseConnection(connection);
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        return isConnected;
    }
}

