/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap.exception;

import java.util.List;
import org.gluu.site.ldap.exception.LugeException;

public class InvalidEntryException
extends LugeException {
    private static final long serialVersionUID = 1756816743469359856L;
    private List<String> missingAttributes;

    private static String generateMissingString(List<String> missing) {
        String missingString = "";
        for (String attr : missing) {
            missingString = missingString + attr + " ";
        }
        return missingString;
    }

    public InvalidEntryException(List<String> missing) {
        super("Invalid entry: The following attributes must be present: " + InvalidEntryException.generateMissingString(missing));
        this.missingAttributes = missing;
    }

    public InvalidEntryException(String message) {
        super(message);
    }

    public InvalidEntryException(String message, Exception e) {
        super(message, e);
    }

    public List<String> getMissingAttributes() {
        return this.missingAttributes;
    }

    public void setMissingAttributes(List<String> missingAttributes) {
        this.missingAttributes = missingAttributes;
    }
}

