/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap.persistence.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.gluu.site.ldap.persistence.exception.MappingException;
import org.gluu.site.ldap.persistence.exception.PropertyNotFoundException;
import org.gluu.site.ldap.persistence.property.BasicPropertyAccessor;
import org.gluu.site.ldap.persistence.property.BasicPropertyAnnotationResolver;
import org.gluu.site.ldap.persistence.property.DirectPropertyAccessor;
import org.gluu.site.ldap.persistence.property.Getter;
import org.gluu.site.ldap.persistence.property.PropertyAccessor;
import org.gluu.site.ldap.persistence.property.Setter;

public final class ReflectHelper {
    private static final PropertyAccessor BASIC_PROPERTY_ACCESSOR;
    private static final PropertyAccessor DIRECT_PROPERTY_ACCESSOR;
    private static final BasicPropertyAnnotationResolver BASIC_PROPERTY_ANNOTATION_RESOLVER;
    public static final Class<?>[] NO_PARAM_SIGNATURE;
    public static final Object[] NO_PARAMS;
    public static final Annotation[] NO_ANNOTATIONS;
    public static final Class<?>[] SINGLE_OBJECT_PARAM_SIGNATURE;
    private static final Method OBJECT_EQUALS;
    private static final Method OBJECT_HASHCODE;

    private ReflectHelper() {
    }

    public static Method extractEqualsMethod(Class<?> clazz) throws NoSuchMethodException {
        return clazz.getMethod("equals", SINGLE_OBJECT_PARAM_SIGNATURE);
    }

    public static Method extractHashCodeMethod(Class<?> clazz) throws NoSuchMethodException {
        return clazz.getMethod("hashCode", NO_PARAM_SIGNATURE);
    }

    public static boolean overridesEquals(Class<?> clazz) {
        Method equals;
        try {
            equals = ReflectHelper.extractEqualsMethod(clazz);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_EQUALS.equals(equals);
    }

    public static boolean overridesHashCode(Class<?> clazz) {
        Method hashCode;
        try {
            hashCode = ReflectHelper.extractHashCodeMethod(clazz);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_HASHCODE.equals(hashCode);
    }

    public static boolean assignableFrom(Class<?> clazz, Class<?> intf) {
        return intf.isAssignableFrom(clazz);
    }

    public static Class<?> classForName(String name, Class<?> caller) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(name, true, caller.getClassLoader());
    }

    public static Class<?> classForName(String name) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(name);
    }

    public static boolean isPublic(Member member) {
        return ReflectHelper.isPublic(member.getDeclaringClass(), member);
    }

    public static boolean isPublic(Class<?> clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static Class<?> reflectedPropertyClass(String className, String name) throws MappingException {
        try {
            Class<?> clazz = ReflectHelper.classForName(className);
            return ReflectHelper.getter(clazz, name).getReturnType();
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("class " + className + " not found while looking for property: " + name, cnfe);
        }
    }

    private static Getter getter(Class<?> clazz, String name) throws MappingException {
        try {
            return BASIC_PROPERTY_ACCESSOR.getGetter(clazz, name);
        }
        catch (PropertyNotFoundException pnfe) {
            return DIRECT_PROPERTY_ACCESSOR.getGetter(clazz, name);
        }
    }

    private static Setter setter(Class<?> clazz, String name) throws MappingException {
        try {
            return BASIC_PROPERTY_ACCESSOR.getSetter(clazz, name);
        }
        catch (PropertyNotFoundException pnfe) {
            return DIRECT_PROPERTY_ACCESSOR.getSetter(clazz, name);
        }
    }

    public static Getter getGetter(Class<?> theClass, String name) throws MappingException {
        return BASIC_PROPERTY_ACCESSOR.getGetter(theClass, name);
    }

    public static Getter getMethodOrPropertyGetter(Class<?> theClass, String name) throws MappingException {
        return ReflectHelper.getter(theClass, name);
    }

    public static Setter getSetter(Class<?> theClass, String name) throws MappingException {
        return BASIC_PROPERTY_ACCESSOR.getSetter(theClass, name);
    }

    public static Setter getMethodOrPropertySetter(Class<?> theClass, String name) throws MappingException {
        return ReflectHelper.setter(theClass, name);
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) throws PropertyNotFoundException {
        if (ReflectHelper.isAbstractClass(clazz)) {
            return null;
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(NO_PARAM_SIGNATURE);
            if (!ReflectHelper.isPublic(clazz, constructor)) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException nme) {
            throw new PropertyNotFoundException("Object class [" + clazz.getName() + "] must declare a default (no-argument) constructor");
        }
    }

    public static <T> T createObjectByDefaultConstructor(Class<T> clazz) throws PropertyNotFoundException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ReflectHelper.getDefaultConstructor(clazz).newInstance(NO_PARAMS);
    }

    public static boolean isAbstractClass(Class<?> clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isAbstract(modifier) || Modifier.isInterface(modifier);
    }

    public static boolean isFinalClass(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... parameterTypes) throws PropertyNotFoundException {
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw new PropertyNotFoundException("Object class [" + clazz.getName() + "] must declare constructor with specifid types [" + parameterTypes + "]");
        }
        if (constructor != null) {
            if (!ReflectHelper.isPublic(clazz, constructor)) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        throw new PropertyNotFoundException("no appropriate constructor in class: " + clazz.getName());
    }

    public static Method getMethod(Class<?> clazz, Method method) {
        try {
            return clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Annotation getAnnotationByType(List<Annotation> annotations, Class<?> annotationType) {
        if (annotations == null) {
            return null;
        }
        return ReflectHelper.getAnnotationByType(annotations.toArray(NO_ANNOTATIONS), annotationType);
    }

    public static Annotation getAnnotationByType(Annotation[] annotations, Class<?> annotationType) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return annotation;
        }
        return null;
    }

    public static String getPropertyNameByType(Map<String, List<Annotation>> propertiesAnnotations, Class<?> annotationType) {
        for (Map.Entry<String, List<Annotation>> propertiesAnnotation : propertiesAnnotations.entrySet()) {
            Annotation annotation = ReflectHelper.getAnnotationByType(propertiesAnnotation.getValue(), annotationType);
            if (annotation == null) continue;
            return propertiesAnnotation.getKey();
        }
        return null;
    }

    public static boolean isNotPrimitiveClass(Class<?> theClass) {
        return theClass != null && !theClass.equals(Object.class) && !theClass.isPrimitive();
    }

    public static List<Annotation> getClassAnnotations(Class<?> theClass, Class<?> ... allowedAnnotations) throws PropertyNotFoundException {
        return BASIC_PROPERTY_ANNOTATION_RESOLVER.getClassAnnotations(theClass, allowedAnnotations);
    }

    public static List<Annotation> getPropertyAnnotations(Class<?> theClass, String propertyName, Class<?> ... allowedAnnotations) throws PropertyNotFoundException {
        return BASIC_PROPERTY_ANNOTATION_RESOLVER.getPropertyAnnotations(theClass, propertyName, allowedAnnotations);
    }

    public static Map<String, List<Annotation>> getPropertiesAnnotations(Class<?> theClass, Class<?> ... allowedAnnotations) {
        return BASIC_PROPERTY_ANNOTATION_RESOLVER.getPropertiesAnnotations(theClass, allowedAnnotations);
    }

    public static Class<?> getListType(Getter getter) {
        if (getter == null) {
            return null;
        }
        Type type = getter.getMethod().getGenericReturnType();
        if (ReflectHelper.assignableFrom(type.getClass(), ParameterizedType.class)) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    public static Class<?> getListType(Setter setter) {
        if (setter == null) {
            return null;
        }
        Type[] types = setter.getMethod().getGenericParameterTypes();
        if (ReflectHelper.assignableFrom(ParameterizedType[].class, types.getClass())) {
            return (Class)((ParameterizedType)types[0]).getActualTypeArguments()[0];
        }
        return null;
    }

    public static Class<?> getSetterType(Setter setter) {
        if (setter == null) {
            return null;
        }
        return setter.getMethod().getParameterTypes()[0];
    }

    public static Object getValue(Object object, String name) throws MappingException {
        if (object == null) {
            throw new MappingException("Input value is null");
        }
        Getter getter = BASIC_PROPERTY_ACCESSOR.getGetter(object.getClass(), name);
        return getter.get(object);
    }

    public static Object createArray(Class<?> clazz, int length) {
        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), length);
        }
        return Array.newInstance(clazz, length);
    }

    public static Object getPropertyValue(Object entry, Getter[] propertyGetters) {
        if (entry == null || propertyGetters.length == 0) {
            return null;
        }
        Object curEntry = entry;
        for (Getter propertyGetter : propertyGetters) {
            if (curEntry == null) break;
            curEntry = propertyGetter.get(curEntry);
        }
        return curEntry;
    }

    public static void copyObjectPropertyValues(Object fromEntry, Object toEntry, Getter[] propertyGetters, Setter[] propertySetters) {
        if (fromEntry == null || toEntry == null || propertyGetters.length == 0) {
            return;
        }
        if (propertyGetters.length != propertySetters.length) {
            throw new MappingException("Invalid numbers of setters specified");
        }
        for (int i = 0; i < propertyGetters.length; ++i) {
            Object value = propertyGetters[i].get(fromEntry);
            propertySetters[i].set(toEntry, value);
        }
    }

    public static void sumObjectPropertyValues(Object resultEntry, Object entryToAdd, Getter[] propertyGetters, Setter[] propertySetters) {
        if (resultEntry == null || entryToAdd == null || propertyGetters.length == 0) {
            return;
        }
        if (propertyGetters.length != propertySetters.length) {
            throw new MappingException("Invalid numbers of setters specified");
        }
        for (int i = 0; i < propertyGetters.length; ++i) {
            Number resultValue;
            Number num2;
            Number num1;
            Class<?> returnType = propertyGetters[i].getReturnType();
            Object value1 = propertyGetters[i].get(resultEntry);
            Object value2 = propertyGetters[i].get(entryToAdd);
            if (returnType == Integer.TYPE || returnType == Integer.class) {
                num1 = value1 == null ? 0 : (Integer)value1;
                num2 = value2 == null ? 0 : (Integer)value2;
                resultValue = 0 + (Integer)num1 + (Integer)num2;
            } else if (returnType == Float.TYPE || returnType == Float.class) {
                num1 = Float.valueOf(value1 == null ? 0.0f : ((Float)value1).floatValue());
                num2 = Float.valueOf(value2 == null ? 0.0f : ((Float)value2).floatValue());
                resultValue = Float.valueOf(0.0f + ((Float)num1).floatValue() + ((Float)num2).floatValue());
            } else if (returnType == Double.TYPE || returnType == Double.class) {
                num1 = value1 == null ? 0.0 : (Double)value1;
                num2 = value2 == null ? 0.0 : (Double)value2;
                resultValue = 0.0 + (Double)num1 + (Double)num2;
            } else {
                throw new MappingException("Invalid return type of method " + propertyGetters[i].getMethodName());
            }
            propertySetters[i].set(resultEntry, resultValue);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] methodParams) throws NoSuchMethodException {
        try {
            return clazz.getMethod(methodName, methodParams);
        }
        catch (Exception ex) {
            throw new NoSuchMethodException("Method " + methodName + " doesn't exist in class " + clazz);
        }
    }

    static {
        Method hash;
        Method eq;
        BASIC_PROPERTY_ACCESSOR = new BasicPropertyAccessor();
        DIRECT_PROPERTY_ACCESSOR = new DirectPropertyAccessor();
        BASIC_PROPERTY_ANNOTATION_RESOLVER = new BasicPropertyAnnotationResolver();
        NO_PARAM_SIGNATURE = new Class[0];
        NO_PARAMS = new Object[0];
        NO_ANNOTATIONS = new Annotation[0];
        SINGLE_OBJECT_PARAM_SIGNATURE = new Class[]{Object.class};
        try {
            eq = ReflectHelper.extractEqualsMethod(Object.class);
            hash = ReflectHelper.extractHashCodeMethod(Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find Object.equals() or Object.hashCode()", e);
        }
        OBJECT_EQUALS = eq;
        OBJECT_HASHCODE = hash;
    }
}

