/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.graphmodel.parse;

import org.junit.Assert;
import org.junit.Test;
import org.xdi.graphmodel.api.GetOpFilterType;
import org.xdi.graphmodel.impl.GetOpFilter;

public class GetOpFilterParserTest {
    @Test
    public void test() {
        this.assertParser("$get$literal$binary", "", GetOpFilterType.LITERAL, GetOpFilterType.BINARY);
        this.assertParser("$get($and(xri=*age/!)(value>36))", "($and(xri=*age/!)(value>36))", new GetOpFilterType[0]);
        this.assertParser("$get$binary($and(xri=*age/!)(value>36))", "($and(xri=*age/!)(value>36))", GetOpFilterType.BINARY);
    }

    private void assertParser(String p_string, String p_expression, GetOpFilterType ... p_type) {
        GetOpFilter filter = GetOpFilter.valueOf((String)p_string);
        Assert.assertTrue((filter != null && filter.getExpression().equals(p_expression) ? 1 : 0) != 0);
        if (p_type != null) {
            for (GetOpFilterType t : p_type) {
                Assert.assertTrue((boolean)filter.contains(t));
            }
        }
    }
}

