/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.graphmodel.parse;

import org.junit.Assert;
import org.junit.Test;
import org.xdi.graphmodel.api.MediaType;
import org.xdi.graphmodel.api.graph.XdiStatement;
import org.xdi.graphmodel.impl.DataUriSchema;
import org.xdi.graphmodel.impl.XdiStatementImpl;

public class DataUriSchemaParserTest {
    @Test
    public void test() {
        DataUriSchema d1 = DataUriSchema.fromDataUriString((String)"data:image/png;base64,sdfasdfdsfasdfasdf");
        Assert.assertTrue(((d1.getCharset() == null || d1.getCharset().equals("")) && d1.getMediaType() == MediaType.IMAGE_PNG && d1.isBinary() ? 1 : 0) != 0);
        DataUriSchema d2 = DataUriSchema.fromDataUriString((String)"data:application/xdi+json;charset=utf-8,sdfasdfdsfasdfasdf");
        Assert.assertTrue((d2.getMediaType() == MediaType.APPLICATION_XDI_JSON && d2.getCharset().equals("utf-8") && !d2.isBinary() ? 1 : 0) != 0);
        DataUriSchema d3 = DataUriSchema.fromDataUriString((String)"application/xdi+json; charset=UTF-8");
        Assert.assertTrue((d3.getMediaType() == MediaType.APPLICATION_XDI_JSON && d3.getCharset().equals("UTF-8") ? 1 : 0) != 0);
    }

    @Test
    public void st() {
        XdiStatement st = XdiStatementImpl.valueOf((String)"@!4444/!/(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABMAAAATCA)");
        MediaType mediaType = DataUriSchema.fromDataUriString((String)st.getObject().asString()).getMediaType();
        Assert.assertTrue((mediaType == MediaType.IMAGE_PNG ? 1 : 0) != 0);
    }
}

