/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.graphmodel.parse;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.xdi.graphmodel.TUtils;
import org.xdi.graphmodel.api.RootNode;
import org.xdi.graphmodel.api.graph.XdiArc;
import org.xdi.graphmodel.api.graph.XdiNode;
import org.xdi.graphmodel.common.Utils;

public class BuildGraphWithoutRoot {
    @Test
    public void test() {
        List list = Utils.convert((String[])new String[]{"@!1111!0000/()/!1", "@mustardseed*person/()/*bob", "@mustardseed*person*bob/$is/@!1111!0000!1"});
        RootNode graph = TUtils.BUILDER.createGraph(list);
        Assert.assertTrue((graph != null ? 1 : 0) != 0);
        for (XdiArc arc : graph.getContextualArcList()) {
            Assert.assertTrue((boolean)arc.isFake());
        }
        XdiArc _1111_0000_1 = Utils.getArcByXri((Collection)Utils.targetContextualNode((XdiNode)graph, (String)"@!1111!0000").getContextualArcList(), (String)"!1");
        Assert.assertFalse((boolean)_1111_0000_1.isFake());
        XdiArc _mustardseed_person_bob = Utils.getArcByXri((Collection)Utils.targetContextualNode((XdiNode)graph, (String)"@mustardseed*person").getContextualArcList(), (String)"*bob");
        Assert.assertFalse((boolean)_mustardseed_person_bob.isFake());
        XdiArc _is = Utils.getArcByXri((Collection)_mustardseed_person_bob.getTarget().getRelationalArcList(), (String)"$is");
        Assert.assertTrue((!_is.isFake() && _is.getTarget().equals(_1111_0000_1.getTarget()) ? 1 : 0) != 0);
        List extractedList = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)graph);
        extractedList.removeAll(list);
        Assert.assertTrue((boolean)extractedList.isEmpty());
    }

    @Test
    public void test_YuraM_example1() {
        List list = Utils.convert((String[])new String[]{"@!2222!0000!1*linkcontracts/()/!1", "@!2222!0000!1/()/*linkcontracts", "@!2222!0000!1*linkcontracts!1$do/$is$do/@!2222!0000!1", "@!2222!0000!1*linkcontracts!1/()/$do", "@!2222!0000!1*linkcontracts!1$do/$all/@!2222!0000!1"});
        RootNode graph = TUtils.BUILDER.createGraph(list);
        Assert.assertTrue((graph.getContextualArcList().size() == 1 ? 1 : 0) != 0);
    }
}

