/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.graphmodel.operation;

import org.xdi.graphmodel.BaseTestCase;
import org.xdi.graphmodel.TUtils;
import org.xdi.graphmodel.TestGraphBuilder;
import org.xdi.graphmodel.api.LiteralNode;
import org.xdi.graphmodel.api.RootNode;
import org.xdi.graphmodel.api.graph.XdiNode;
import org.xdi.graphmodel.api.operation.Operation;
import org.xdi.graphmodel.api.operation.OperationResult;
import org.xdi.graphmodel.api.xri.Xri;
import org.xdi.graphmodel.impl.GraphExtractorImpl;
import org.xdi.graphmodel.impl.XdiStatementImpl;
import org.xdi.graphmodel.impl.xri.XriImpl;

public class ModifyOperationTest
extends BaseTestCase {
    public void testModify() {
        RootNode graph = TestGraphBuilder.createComplexPropertiesGraph20110404();
        Operation operation = TUtils.OPERATION_FACTORY.create(XdiStatementImpl.valueOf((String)"fromSegment$do/$mod/(=abc+tel!1/$d!/(data:,2022-22-22T22:22:22Z))"));
        OperationResult result = operation.apply(graph);
        ModifyOperationTest.assertTrue((result != null && result.getSuccessful() ? 1 : 0) != 0);
        LiteralNode node = (LiteralNode)GraphExtractorImpl.getInstance().getNodeByXri((XdiNode)graph, (Xri)new XriImpl(new String[]{"=abc+tel!1/$d!"}));
        ModifyOperationTest.assertTrue((boolean)node.getValue().asString().equals("2022-22-22T22:22:22Z"));
    }

    public void testModify_Negative() {
        RootNode graph = TestGraphBuilder.createComplexPropertiesGraph20110404();
        Operation operationNull = TUtils.OPERATION_FACTORY.create(XdiStatementImpl.valueOf((String)"fromSegment$do/$mod/(=abc+tel!1/()/sd)"));
        ModifyOperationTest.assertTrue((operationNull == null ? 1 : 0) != 0);
        Operation operation = TUtils.OPERATION_FACTORY.create(XdiStatementImpl.valueOf((String)"fromSegment$do/$mod/(=abc1111/$d!/(data:,2022-22-22T22:22:22Z))"));
        OperationResult result = operation.apply(graph);
        ModifyOperationTest.assertTrue((result != null && !result.getSuccessful() ? 1 : 0) != 0);
    }
}

