/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.graphmodel.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xdi.graphmodel.BaseTestCase;
import org.xdi.graphmodel.TUtils;
import org.xdi.graphmodel.TestGraphBuilder;
import org.xdi.graphmodel.api.RootNode;
import org.xdi.graphmodel.api.graph.XdiStatement;
import org.xdi.graphmodel.api.operation.Operation;
import org.xdi.graphmodel.api.operation.OperationResult;
import org.xdi.graphmodel.common.Utils;
import org.xdi.graphmodel.impl.XdiStatementImpl;

public class GetOperationTest
extends BaseTestCase {
    public void testGet_ComplexSubject() {
        String xri = "=abc$v";
        List expectedList = Utils.convert((String[])new String[]{"=abc$v/()/!1", "=abc$v/()/!2", "=abc$v!2/$/=abc"});
        this.internalTest("=abc$v", "Complex properties", TestGraphBuilder.createComplexSubject20110404(), expectedList);
    }

    public void testGet_SimpleProperties_LiteralNode() {
        String xri = "(=abc/+age!)";
        ArrayList<XdiStatement> expectedList = new ArrayList<XdiStatement>();
        expectedList.add(XdiStatementImpl.valueOf((String)"=abc/+age!/(data:,33)"));
        this.internalTest("(=abc/+age!)", "Simple properties", TestGraphBuilder.createSimpleProperties20110404(), expectedList);
    }

    public void testGet_SimpleProperties() {
        String xri = "=abc+age$v";
        List expectedList = Utils.convert((String[])new String[]{"=abc+age$v/()/!1", "=abc+age$v/()/!2", "=abc+age$v/!1!/(data:,32)", "=abc+age$v!1/$d!/(data:,2010-09-09T10:11:12Z)", "=abc+age$v!2/$d!/(data:,2010-10-10T11:12:13Z)", "=abc+age$v/!2/(=abc/+age!)"});
        this.internalTest("=abc+age$v", "Simple properties", TestGraphBuilder.createSimpleProperties20110404(), expectedList);
    }

    private void internalTest(String p_nodeXri, String p_graphName, RootNode p_graph, List<XdiStatement> p_expectedList) {
        System.out.println("Test $get operation for '" + p_graphName + "'Social graph, node xri: " + p_nodeXri);
        XdiStatement commandStatement = XdiStatementImpl.valueOf((String)("fromSegment$do/$get/" + p_nodeXri));
        Operation operation = TUtils.OPERATION_FACTORY.create(commandStatement);
        OperationResult result = operation.apply(p_graph);
        List list = result.getList();
        GetOperationTest.assertTrue((list != null && !list.isEmpty() ? 1 : 0) != 0);
        Utils.printList((Collection)list);
        list.removeAll(p_expectedList);
        GetOperationTest.assertTrue((boolean)list.isEmpty());
        System.out.println("--------- Test passed!");
    }
}

