/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.graphmodel.operation;

import java.util.List;
import org.xdi.graphmodel.BaseTestCase;
import org.xdi.graphmodel.TUtils;
import org.xdi.graphmodel.TestGraphBuilder;
import org.xdi.graphmodel.api.RootNode;
import org.xdi.graphmodel.api.graph.XdiNode;
import org.xdi.graphmodel.api.graph.XdiStatement;
import org.xdi.graphmodel.api.operation.Operation;
import org.xdi.graphmodel.api.operation.OperationResult;
import org.xdi.graphmodel.common.Utils;
import org.xdi.graphmodel.impl.XdiStatementImpl;
import org.xdi.graphmodel.impl.operation.AddOperationImpl;

public class AddOperationTest
extends BaseTestCase {
    @Override
    protected List<XdiStatement> expectedXdiStatementList() {
        List list = Utils.convert((String[])new String[]{"()/()/=abc", "=abc/()/+age", "=abc/+age!/(data:,33)", "=abc+age/()/$v", "=abc+age/$v/=abc+age$v!2", "=abc+age/$d!/(data:,2010-10-10T11:12:13Z)", "=abc+age$v/()/!1", "=abc+age$v/()/!2", "=abc+age$v/!2/(=abc/+age!)", "=abc+age$v/!1!/(data:,32)", "=abc+age$v!1/$d!/(data:,2010-09-09T10:11:12Z)", "=abc+age$v!2/$d!/(data:,2010-10-10T11:12:13Z)"});
        return list;
    }

    public void testContextualArc() {
        String command = "fromSegment$do/$add/(=abc/()/xyz)";
        RootNode graph = TestGraphBuilder.createSimpleProperties20110404();
        XdiStatement commandStatement = XdiStatementImpl.valueOf((String)"fromSegment$do/$add/(=abc/()/xyz)");
        Operation operation = TUtils.OPERATION_FACTORY.create(commandStatement);
        AddOperationTest.assertTrue((boolean)(operation instanceof AddOperationImpl));
        OperationResult apply = operation.apply(graph);
        AddOperationTest.assertTrue((apply != null && apply.getSuccessful() ? 1 : 0) != 0);
        List list = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)graph);
        list.removeAll(this.expectedXdiStatementList());
        AddOperationTest.assertTrue((list.size() == 1 && ((XdiStatement)list.get(0)).asString().equals("=abc/()/xyz") ? 1 : 0) != 0);
    }

    public void testRelationalArcToContextualNode() {
        String command = "fromSegment$do/$add/(=abc/$/=abc+age$v!1)";
        RootNode graph = TestGraphBuilder.createSimpleProperties20110404();
        XdiStatement commandStatement = XdiStatementImpl.valueOf((String)"fromSegment$do/$add/(=abc/$/=abc+age$v!1)");
        Operation operation = TUtils.OPERATION_FACTORY.create(commandStatement);
        AddOperationTest.assertTrue((boolean)(operation instanceof AddOperationImpl));
        OperationResult apply = operation.apply(graph);
        AddOperationTest.assertTrue((apply != null && apply.getSuccessful() ? 1 : 0) != 0);
        List list = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)graph);
        list.removeAll(this.expectedXdiStatementList());
        AddOperationTest.assertTrue((list.size() == 1 && ((XdiStatement)list.get(0)).asString().equals("=abc/$/=abc+age$v!1") ? 1 : 0) != 0);
    }

    public void testRelationalArcToLiteralNode() {
        String command = "fromSegment$do/$add/(=abc/($)/(=abc+age/$d!))";
        RootNode graph = TestGraphBuilder.createSimpleProperties20110404();
        XdiStatement commandStatement = XdiStatementImpl.valueOf((String)"fromSegment$do/$add/(=abc/($)/(=abc+age/$d!))");
        Operation operation = TUtils.OPERATION_FACTORY.create(commandStatement);
        AddOperationTest.assertTrue((boolean)(operation instanceof AddOperationImpl));
        OperationResult apply = operation.apply(graph);
        AddOperationTest.assertTrue((apply != null && apply.getSuccessful() ? 1 : 0) != 0);
        List list = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)graph);
        list.removeAll(this.expectedXdiStatementList());
        AddOperationTest.assertTrue((list.size() == 1 && ((XdiStatement)list.get(0)).asString().equals("=abc/($)/(=abc+age/$d!)") ? 1 : 0) != 0);
    }

    public void testLiteralArc() {
        String command = "fromSegment$do/$add/(=abc+age/!1!/(data:,2010-10-10T11:12:13Z))";
        RootNode graph = TestGraphBuilder.createSimpleProperties20110404();
        XdiStatement commandStatement = XdiStatementImpl.valueOf((String)"fromSegment$do/$add/(=abc+age/!1!/(data:,2010-10-10T11:12:13Z))");
        Operation operation = TUtils.OPERATION_FACTORY.create(commandStatement);
        AddOperationTest.assertTrue((boolean)(operation instanceof AddOperationImpl));
        OperationResult apply = operation.apply(graph);
        AddOperationTest.assertTrue((apply != null && apply.getSuccessful() ? 1 : 0) != 0);
        List list = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)graph);
        list.removeAll(this.expectedXdiStatementList());
        AddOperationTest.assertTrue((list.size() == 1 && ((XdiStatement)list.get(0)).asString().equals("=abc+age/!1!/(data:,2010-10-10T11:12:13Z)") ? 1 : 0) != 0);
    }
}

