package org.xdi.graphmodel.impl.xri;

import org.xdi.graphmodel.api.xri.Xri;

/**
 * XRI implementation based on string.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 25/03/2011
 */
public class XriImpl implements Xri {

    private final String m_xri;

    /**
     * Constructor
     *
     * @param p_xri xri string value
     */
    public XriImpl(String... p_xri) {
        if (p_xri != null) {
            final int length = p_xri.length;
            if (length > 0) {
                final StringBuilder b = new StringBuilder(p_xri[0]);
                for (int i = 1; i < length; i++) {
                    b.append(p_xri[i]);
                }
                m_xri = b.toString();
            } else {
                m_xri = null;
            }
        } else {
            m_xri = null;
        }
    }

    /**
     * @return string representation of xri
     */
    public String asString() {
        return m_xri != null ? m_xri : "";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        final XriImpl xri = (XriImpl) o;

        return !(m_xri != null ? !m_xri.equalsIgnoreCase(xri.m_xri) : xri.m_xri != null);
    }

    @Override
    public int hashCode() {
        return m_xri != null ? m_xri.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "XriImpl{" +
                "m_xri='" + m_xri + '\'' +
                '}';
    }
}
