package org.xdi.graphmodel.impl.xri;

import org.xdi.graphmodel.api.ContextNode;
import org.xdi.graphmodel.api.LiteralNode;
import org.xdi.graphmodel.api.RootNode;
import org.xdi.graphmodel.api.Symbols;
import org.xdi.graphmodel.api.graph.XdiArc;
import org.xdi.graphmodel.api.graph.XdiNode;
import org.xdi.graphmodel.api.xri.Xri;

import java.util.Set;

/**
 * Evaluates xri for any node within the graph. (Node MUST NOT be isolated.)
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 25/03/2011
 */
public class XriEvaluator {

    /**
     * Private constructor to forbid new instance creation.
     */
    private XriEvaluator() {
    }

    /**
     * Evaluates xri of node.
     *
     * @param node any node of graph (but not isolated one)
     * @return xri of node
     */
    public static Xri evaluate(XdiNode node) {
        String xri = "";
        if (node instanceof RootNode) {
            xri = Symbols.PARENTHESIS.getValue();
        } else if (node instanceof ContextNode) {
            final Set<XdiArc> list = node.getContextualArcList();
            for (XdiArc arc : list) {
                if (arc.getTarget().equals(node)) {
                    final XdiNode source = arc.getSource();
                    if (source instanceof RootNode) {
                        xri = arc.getXri().asString();
                    } else {
                        final StringBuilder b = new StringBuilder(source.getXri().asString());
                        b.append(arc.getXri().asString());
                        xri = b.toString();
                    }
                    break;
                }
            }
        } else if (node instanceof LiteralNode) {
            final Set<XdiArc> literalArcList = node.getLiteralArcList();
            for (XdiArc arc : literalArcList) {
                if (arc.getTarget().equals(node)) {
                    final StringBuilder b = new StringBuilder(arc.getSource().getXri().asString());
                    b.append(Symbols.SLASH.getValue());
                    b.append(arc.getXri().asString());
                    xri = b.toString();
                    break;
                }
            }
        } else {
            throw new RuntimeException("Enable to identify node type");
        }
        return new XriImpl(xri);
    }
}
