package org.xdi.graphmodel.impl.operation;

import org.xdi.graphmodel.api.graph.XdiStatement;
import org.xdi.graphmodel.api.operation.OperationResult;

import java.util.ArrayList;
import java.util.List;

/**
 * Implementation of operation result interface.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 09/05/2011
 */
public class OperationResultImpl implements OperationResult {

    /**
     * Whether operation was executed successfully
     */
    private final boolean m_successful;

    /**
     * List of xdi statements
     */
    private final List<XdiStatement> m_list;

    /**
     * Constructor
     *
     * @param p_successful whether operation was executed successfully
     */
    public OperationResultImpl(boolean p_successful) {
        this(p_successful, new ArrayList<XdiStatement>());
    }

    /**
     * Default constructor
     *
     * @param p_successful whether operation was executed successfully
     * @param p_list       list of xdi statements
     */
    public OperationResultImpl(boolean p_successful, List<XdiStatement> p_list) {
        m_successful = p_successful;
        m_list = p_list;
    }

    /**
     * Returns whether operation was executed successfully.
     *
     * @return whether operation was executed successfully
     */
    public boolean getSuccessful() {
        return m_successful;
    }

    /**
     * Returns xdi statement list (not always, depends on operation).
     *
     * @return xdi statement list (not always, depends on operation)
     */
    public List<XdiStatement> getList() {
        return m_list;
    }
}
