package org.xdi.graphmodel.impl;

import org.xdi.graphmodel.api.graph.XdiArc;
import org.xdi.graphmodel.api.graph.XdiNode;
import org.xdi.graphmodel.api.xri.Xri;

/**
 * Arc implementation of graph model. Contains information about 3 basic elements of arc:
 * source of arc (node), target of arc (node) and xri of arc.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 25/03/2011
 */
public class XdiArcImpl implements XdiArc {

    private final XdiNode m_source;
    private final XdiNode m_target;
    private final Xri m_xri;
    private boolean m_fake = false;

    /**
     * Constructor.
     *
     * @param p_source source node
     * @param p_target target node
     * @param p_xri    xri of arc
     */
    public XdiArcImpl(XdiNode p_source, XdiNode p_target, Xri p_xri) {
        m_source = p_source;
        m_target = p_target;
        m_xri = p_xri;
    }

    /**
     * @return source node of arc
     */
    public XdiNode getSource() {
        return m_source;
    }

    /**
     * @return target node of arc
     */
    public XdiNode getTarget() {
        return m_target;
    }

    /**
     * @return xri of arc
     */
    public Xri getXri() {
        return m_xri;
    }

    /**
     * Returns whether arc is fake.
     *
     * @return whether arc is fake
     */
    @Override
    public boolean isFake() {
        return m_fake;
    }

    /**
     * Sets fake indicator.
     *
     * @param p_fake fake
     */
    @Override
    public void setFake(boolean p_fake) {
        m_fake = p_fake;
    }

    @Override
    public String toString() {
        return "XdiArcImpl{" +
                "m_source=" + m_source +
                ", m_target=" + m_target +
                ", m_xriPart=" + m_xri +
                ", m_fake=" + m_fake +
                '}';
    }
}
