package org.xdi.graphmodel.impl;

import org.xdi.graphmodel.api.Variable;

/**
 * Variable interface implementation.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 16/01/2012
 */

public class VariableImpl implements Variable {

    /**
     * Variable
     */
    private final String m_variable;

    /**
     * Constructor
     *
     * @param p_variable variable
     */
    public VariableImpl(String p_variable) {
        m_variable = p_variable;
    }

    /**
     * Gets variable.
     *
     * @return variable
     */
    public String getVariable() {
        return m_variable;
    }

    /**
     * Returns variable.
     *
     * @return variable
     */
    @Override
    public String asString() {
        return m_variable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VariableImpl variable = (VariableImpl) o;

        return !(m_variable != null ? !m_variable.equals(variable.m_variable) : variable.m_variable != null);
    }

    @Override
    public int hashCode() {
        return m_variable != null ? m_variable.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "VariableImpl{" +
                "m_variable='" + m_variable + '\'' +
                '}';
    }
}
