package org.xdi.graphmodel.impl;

import org.xdi.graphmodel.api.RootNode;
import org.xdi.graphmodel.api.graph.XdiNode;
import org.xdi.graphmodel.api.graph.XdiStatement;


/**
 * Implementation of root node according to xdi pattern notation. Each graph must contain only one root node.
 * Graph node that doesn't have any root node is invalid and can't be considered as correct.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 25/03/2011
 */
public class RootNodeImpl extends AbstractXdiNode implements RootNode {

    /**
     * Gets parent node. Parent of root node is always null.
     *
     * @return parent node.
     */
    public XdiNode getParent() {
        return null;
    }

    /**
     * Gets xdi statement.
     *
     * @return xdi statement
     */
    public XdiStatement getXdiStatement() {
        return null;
    }

    /**
     * Gets type.
     *
     * @return type
     */
    public XdiStatement.ArcType getType() {
        return XdiStatement.ArcType.CONTEXTUAL;
    }
}
