package org.xdi.graphmodel.impl;

import org.xdi.graphmodel.api.LiteralNode;
import org.xdi.graphmodel.api.graph.XdiArc;
import org.xdi.graphmodel.api.graph.XdiNode;
import org.xdi.graphmodel.api.graph.XdiStatement;

import java.util.Set;

/**
 * Literal node implementation.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 25/03/2011
 */
public class LiteralNodeImpl extends AbstractXdiNode implements LiteralNode {

    /**
     * Literal node value implementation.
     */
    public static class ValueImpl implements Value {

        private final String m_value;

        /**
         * String constructor.
         *
         * @param p_value string value of literal node
         */
        public ValueImpl(String p_value) {
            m_value = p_value;
        }

        /**
         * @return string representation of literal value
         */
        public String asString() {
            return m_value != null ? m_value : "";
        }
    }

    /**
     * Literal value
     */
    private LiteralNode.Value m_value;

    /**
     * Parent node
     */
    private XdiNode m_parent;

    /**
     * Xdi statement
     */
    private XdiStatement m_xdiStatement;

    /**
     * Empty constructor (value is null).
     */
    public LiteralNodeImpl() {
        this(null);
    }

    /**
     * Constructor with value.
     *
     * @param p_value value of literal node
     */
    public LiteralNodeImpl(LiteralNode.Value p_value) {
        m_value = p_value;
    }

    /**
     * @return value of literal node
     */
    public Value getValue() {
        return m_value;
    }

    /**
     * Sets value of literal node.
     *
     * @param p_value value of literal node
     */
    public void setValue(Value p_value) {
        m_value = p_value;
    }

    /**
     * Gets parent node.
     *
     * @return parent node.
     */
    public XdiNode getParent() {
        if (m_parent == null) {
            m_parent = getParent(getLiteralArcList());
        }
        return m_parent;
    }

    /**
     * Gets xdi statement.
     *
     * @return xdi statement
     */
    public XdiStatement getXdiStatement() {
        if (m_xdiStatement == null) {
            final Set<XdiArc> literalArcList = getLiteralArcList();
            if (literalArcList != null && literalArcList.size() == 1) {
                m_xdiStatement = GraphExtractorImpl.constructLiteralStatementFromLiteralArc(literalArcList.iterator().next());
            }
        }
        return m_xdiStatement;
    }

    /**
     * Gets type.
     *
     * @return type
     */
    public XdiStatement.ArcType getType() {
        return XdiStatement.ArcType.LITERAL;
    }
}
