package org.xdi.graphmodel.impl;

import org.xdi.graphmodel.api.GraphTraversFunction;
import org.xdi.graphmodel.api.graph.XdiNode;

/**
 * Adapter for travers function
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 06/07/2011
 */
public class GraphTraversFunctionAdapter implements GraphTraversFunction {

    /**
     * Apply function to node.
     *
     * @param p_node handled node
     */
    public void apply(XdiNode p_node) {
    }

    /**
     * Returns whether traversing should be terminated or not.
     *
     * @param p_node handled node
     * @return whether traversing should be terminated or not
     */
    public boolean getTerminateCondition(XdiNode p_node) {
        return false;
    }

    /**
     * Returns node on which termination was performed.
     *
     * @return node on which termination was performed
     */
    public XdiNode getTerminateNode() {
        return null;
    }
}
