package org.xdi.graphmodel.impl;

import org.xdi.graphmodel.api.ContextNode;
import org.xdi.graphmodel.api.Symbols;
import org.xdi.graphmodel.api.graph.XdiNode;
import org.xdi.graphmodel.api.graph.XdiStatement;

/**
 * Context node implementation.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 25/03/2011
 * @see ContextNode
 */
public class ContextNodeImpl extends AbstractXdiNode implements ContextNode {

    /**
     * Parent node.
     */
    private XdiNode m_parent;

    /**
     * Xdi statement
     */
    private XdiStatement m_xdiStatement;

    /**
     * Gets parent node.
     *
     * @return parent node.
     */
    public XdiNode getParent() {
        if (m_parent == null) {
            m_parent = getParent(getContextualArcList());
        }
        return m_parent;
    }

    /**
     * Gets xdi statement.
     *
     * @return xdi statement
     */
    public XdiStatement getXdiStatement() {
        if (m_xdiStatement == null) {
            final XdiNode parent = getParent();
            if (parent != null) {
                m_xdiStatement = new XdiStatementImpl(parent.getXri(), Symbols.PARENTHESIS.getXri(), getXri());
            }
        }
        return m_xdiStatement;
    }

    /**
     * Gets type.
     *
     * @return type
     */
    public XdiStatement.ArcType getType() {
        return XdiStatement.ArcType.CONTEXTUAL;
    }
}
