package org.xdi.graphmodel.api.operation;

import org.xdi.graphmodel.api.Symbols;
import org.xdi.graphmodel.api.xri.Xri;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Operation type enumeration.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 09/05/2011
 */
public enum OperationType {
    DO(Symbols.DO_OPERATION),
    GET(Symbols.GET_OPERATION),
    ADD(Symbols.ADD_OPERATION),
    MOD(Symbols.MOD_OPERATION),
    DEL(Symbols.DEL_OPERATION),
    ALL(Symbols.ALL_OPERATION),
    COPY(Symbols.COPY_OPERATION),
    MOVE(Symbols.MOVE_OPERATION),
    ADD_VARIABLE(Symbols.ADD_VARIABLE_OPERATION);

    /**
     * Supported types
     */
    public static final List<OperationType> SUPPORTED_TYPES = Collections.unmodifiableList(Arrays.asList(
            GET, ADD, MOD, DEL, ALL, ADD_VARIABLE
    ));

    /**
     * Symbols class of operation
     */
    private final Symbols m_symbol;

    /**
     * String representation of operation
     */
    private final String m_value;

    /**
     * Xri
     */
    private final Xri m_xri;

    /**
     * Constructor
     *
     * @param p_symbol symbol of operation
     */
    OperationType(Symbols p_symbol) {
        m_symbol = p_symbol;
        m_xri = p_symbol.getXri();
        m_value = p_symbol.getValue();
    }

    /**
     * Returns symbol of operation.
     *
     * @return symbols of operation
     */
    public Symbols getSymbol() {
        return m_symbol;
    }

    /**
     * Returns string value of operation.
     *
     * @return string value of operation
     */
    public String getValue() {
        return m_value;
    }

    /**
     * Gets xri.
     *
     * @return xri
     */
    public Xri getXri() {
        return m_xri;
    }
}
