package org.xdi.graphmodel.api.operation;

import org.xdi.graphmodel.api.graph.XdiStatement;

import java.util.List;

/**
 * Operation execution result.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 09/05/2011
 */
public interface OperationResult {

    /**
     * Returns whether operation was executed successfully.
     *
     * @return whether operation was executed successfully
     */
    public boolean getSuccessful();

    /**
     * Returns xdi statement list (not always, depends on operation).
     *
     * @return xdi statement list (not always, depends on operation)
     */
    public List<XdiStatement> getList();
}
