package org.xdi.graphmodel.api.operation;

import org.xdi.graphmodel.api.RootNode;
import org.xdi.graphmodel.api.graph.XdiStatement;
import org.xdi.graphmodel.api.xri.Xri;

import java.io.Serializable;

/**
 * Operation interface. Represents operation with operands.
 * Know how to apply operation with parameters to graph.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 03/05/2011
 */
public interface Operation<T> extends Serializable {

    /**
     * Apply operation to graph.
     *
     * @param p_graph root of graph
     * @return result of operation execution
     */
    public OperationResult apply(RootNode p_graph);

    /**
     * Original xdi statement with operation (e.g. {from segment}$do/$add/({statement})).
     *
     * @return original xdi statement with operation
     */
    public XdiStatement getOriginalCommandStatement();

    /**
     * Returns operand of operation.
     *
     * @return operand of operation
     */
    public T getOperand();

    /**
     * Gets type of operation.
     *
     * @return type of operation
     */
    public OperationType getType();

    /**
     * Gets link contract node xri.
     *
     * @return Gets link contract node xri
     */
    public Xri getLinkContractNode();

    /**
     * Generates command statement object.
     *
     * @return command statement object
     */
    public String generateCommandStatementObject();
}
