package org.xdi.graphmodel.api.graph;

import org.xdi.graphmodel.api.AsString;
import org.xdi.graphmodel.api.Variable;
import org.xdi.graphmodel.api.xri.Xri;

import java.util.Set;

/**
 * Represents xdi statement. Contains 3 basic elements of xdi statements: subject, predicate, object.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9,  3/27/11
 * @see Xri
 */
public interface XdiStatement extends AsString {

    /**
     * Arc type of xdi statement
     */
    public static enum ArcType {
        UNKNOWN, LITERAL, CONTEXTUAL, RELATIONAL
    }

    /**
     * @return subject in form of xri
     */
    public Xri getSubject();

    /**
     * @return predicate in form of xri
     */
    public Xri getPredicate();

    /**
     * @return object in form of xri
     */
    public Xri getObject();

    /**
     * Returns type of xdi statement
     *
     * @return type of xdi statement
     */
    public ArcType getType();

    /**
     * Gets variables.
     *
     * @return variables
     */
    public Set<Variable> getVariables();

    /**
     * Returns whether statement is "add variable". E.g. =!schwartz/()/{$1}
     *
     * @return whether statement is "add variable"
     */
    public boolean isAddVariableStatement();
}
