package org.xdi.graphmodel.api.graph;

import org.xdi.graphmodel.api.xri.Xri;

/**
 * Core interface that represents node of graph. All specific extension
 * of node must extends this interface.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 3/24/11
 * @see org.xdi.graphmodel.api.LiteralNode
 * @see org.xdi.graphmodel.api.RootNode
 * @see org.xdi.graphmodel.api.ContextNode
 */
public interface XdiNode extends HasContextualArc, HasLiteralArc, HasRelationalArcList {

    /**
     * Gets node xri.
     *
     * @return xri of node
     */
    public Xri getXri();

    /**
     * Gets parent node.
     *
     * @return parent node.
     */
    public XdiNode getParent();

    /**
     * Gets xdi statement.
     *
     * @return xdi statement
     */
    public XdiStatement getXdiStatement();

    /**
     * Gets type.
     *
     * @return type
     */
    XdiStatement.ArcType getType();

    /**
     * Returns whether node is fake.
     *
     * @return whether node is fake
     */
    public boolean isFake();

    /**
     * Sets fake indicator.
     *
     * @param p_fake fake
     */
    public void setFake(boolean p_fake);
}
