package org.xdi.graphmodel.api.graph;

import org.xdi.graphmodel.api.xri.Xri;

/**
 * Arc representation in graph model. Contains information about 3 basic elements of arc:
 * source of arc (node), target of arc (node) and xri of arc.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 25/03/2011
 * @see XdiNode
 */
public interface XdiArc {

    /**
     * @return source node of arc
     */
    public XdiNode getSource();

    /**
     * @return target node of arc
     */
    public XdiNode getTarget();

    /**
     * @return xri of arc
     */
    public Xri getXri();

    /**
     * Returns whether arc is fake.
     *
     * @return whether arc is fake
     */
    public boolean isFake();

    /**
     * Sets fake indicator.
     *
     * @param p_fake fake
     */
    public void setFake(boolean p_fake);
}
