package org.xdi.graphmodel.api;

import org.xdi.graphmodel.api.xri.Xri;
import org.xdi.graphmodel.impl.xri.XriImpl;

/**
 * Contains different symbols and strings which are widely used in xri and xdi statements.
 * Be carefull with using this class because it doesn't consider context of symbol usage.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 28/03/2011
 */
public enum Symbols {
    SLASH("/"),
    ASTERISK("*"),
    EXCLAMATION("!"),
    DOLLAR("$"),
    OPENING_PARENTHESIS("("),
    CLOSING_PARENTHESIS(")"),
    PARENTHESIS("()"),
    LITERAL_DATA("data"),
    COMMA(","),
    COLON(":"),
    NOT("$not"),
    DO_OPERATION("$do"),
    GET_OPERATION("$get"),
    ADD_OPERATION("$add"),
    MOD_OPERATION("$mod"),
    DEL_OPERATION("$del"),
    COPY_OPERATION("$copy"),
    MOVE_OPERATION("$move"),
    ALL_OPERATION("$all"),
    ADD_VARIABLE_OPERATION("$add"),
    SIGNATURE("$sig!"),
    DATE_SYMBOL("$d!"),
    ERROR_SYMBOL("$error"),
    TRUE_SYMBOL("$true"),
    FALSE_SYMBOL("$false"),
    MESSAGE("$msg"),
    VERSION("$v"),
    SYNONYM("$is"),
    LINK_CONTRACT_ASSIGNMENT_OLD("$()"),
    LINK_CONTRACT_ASSIGNMENT("$is$do"),
    LINK_CONTRACT_REUSE("($)"),
    LINK_CONTRACT_IF("$if"),
    LINK_CONTRACT_PUBLIC("$public$do"),
    LINK_CONTRACT_SELF("$self$do"),
    AND_OPERATOR("$and"),
    OR_OPERATOR("$or"),
    NOT_OPERATOR("$not"),
    AUTHORIZATION_TYPE("$authn"),
    TOKEN("$token"),
    URI("$uri"),
    PUBLIC("$public"),
    USER_ID("$uid");

    /**
     * Value
     */
    private final String m_value;

    /**
     * Xri
     */
    private final Xri m_xri;

    /**
     * @param p_value string value of declared symbol
     */
    Symbols(String p_value) {
        m_value = p_value;
        m_xri = new XriImpl(p_value);
    }

    /**
     * @return string value of symbol declaration
     */
    public String getValue() {
        return m_value;
    }

    /**
     * Returns xri.
     *
     * @return xri
     */
    public Xri getXri() {
        return m_xri;
    }

    /**
     * Returns value with prefix
     *
     * @param p_prefix prefix
     * @return value with prefix
     */
    public String getValueWithPrefix(String p_prefix) {
        final StringBuilder b = new StringBuilder(p_prefix);
        return b.append(m_value).toString();
    }
}
