package org.xdi.graphmodel.api;

import org.xdi.graphmodel.api.graph.XdiNode;

/**
 * Represents root node according to xdi pattern notation. Each graph must contain only one root node.
 * Graph node that doesn't have any root node is invalid and can't be considered as correct.
 * <p/>
 * Arcs restrictions for root node are following:
 * <ul>
 * <li>Contextual - only outgoing</li>
 * <li>Literal - only outgoing (as target only literal node)</li>
 * <li>Relational - only outgoing</li>
 * </ul>
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 25/03/2011
 */
public interface RootNode extends XdiNode {
}
