package org.xdi.graphmodel.api;

import org.xdi.graphmodel.api.graph.XdiNode;

/**
 * Represents literal node according to xdi pattern notation.
 * <p/>
 * Arcs restrictions for literal node are following:
 * <ul>
 * <li>Contextual - none</li>
 * <li>Literal - only incoming</li>
 * <li>Relational - only incoming</li>
 * </ul>
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 25/03/2011
 */
public interface LiteralNode extends XdiNode {

    /**
     * Represents literal value of the node.
     */
    public static interface Value extends AsString {
    }

    /**
     * Returns value of literal node.
     *
     * @return value of literal node
     */
    public Value getValue();

    /**
     * Sets value of literal node.
     *
     * @param p_value value of literal node
     */
    public void setValue(Value p_value);
}
